/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.splitLearner.tree;

import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.RegressionTreeNode;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.TreeNode;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.TreeNodePainter;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.TreePainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;

public class RegressionTreePainter
extends TreePainter
implements MouseListener {
    private static final long serialVersionUID = 6173804488982980677L;
    private static final Font MODEL_FONT = new Font("LucidaSans", 0, 9);
    private static final Color MODEL_COLOR = SwingTools.LIGHTEST_YELLOW;
    private static final Color SELECTED_NODE_BORDER_COLOR = Color.RED;
    private static final int MODEL_STRING_BORDER = 3;
    private TreeNode selectedNode;
    private String modelString = "";
    private boolean showModel = false;
    private int showModelX = 0;
    private int showModelY = 0;

    public RegressionTreePainter(TreeNode root, TreeNodePainter painter) {
        super(root, painter);
        this.addMouseListener(this);
    }

    public void paintComponent(Graphics g) {
        if (this.showModel) {
            Graphics2D graphics = (Graphics2D)g;
            Rectangle2D bounds = MODEL_FONT.getStringBounds(this.modelString, graphics.getFontRenderContext());
            bounds.setFrame(0.0, -bounds.getHeight() + 3.0, bounds.getWidth() + 6.0, bounds.getHeight() + 6.0);
            if (this.showModelY + (int)bounds.getHeight() > this.preferredHeight) {
                this.preferredHeight = this.showModelY + (int)bounds.getHeight();
                this.resized = false;
            }
            if (this.showModelX + (int)bounds.getWidth() > this.preferredWidth) {
                this.preferredWidth = this.showModelX + (int)bounds.getWidth();
                this.resized = false;
            }
            super.paintComponent(g);
            Rectangle2D.Double nodeBorder = new Rectangle2D.Double(this.showModelX, this.showModelY - this.maxNodeHeight, this.maxNodeWidth, this.maxNodeHeight + 1);
            graphics.setColor(SELECTED_NODE_BORDER_COLOR);
            graphics.draw(nodeBorder);
            graphics.translate(this.showModelX, this.showModelY + 10 + 1);
            graphics.setColor(MODEL_COLOR);
            graphics.fill(bounds);
            graphics.setColor(Color.BLACK);
            graphics.draw(bounds);
            graphics.setFont(MODEL_FONT);
            graphics.drawString(this.modelString, 3, 3);
        } else {
            super.paintComponent(g);
        }
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int currentLevel = y / (this.maxNodeHeight + 60);
        if (currentLevel < this.levels.size()) {
            for (TreeNode node : (LinkedList)this.levels.get(currentLevel)) {
                int currentShift = (Integer)this.shifts.get(node);
                if (currentShift > x || x > currentShift + this.maxNodeWidth) continue;
                this.paintNodeModel(node, currentShift, currentLevel * (this.maxNodeHeight + 60) + this.maxNodeHeight);
                break;
            }
        }
        this.repaint();
    }

    private void paintNodeModel(TreeNode node, int x, int y) {
        if (node == this.selectedNode) {
            this.showModel = false;
            this.selectedNode = null;
        } else {
            this.modelString = ((RegressionTreeNode)node).getRegressionModel().toString();
            this.showModelX = x;
            this.showModelY = y;
            this.showModel = true;
            this.selectedNode = node;
        }
    }
}

