/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.splitLearner.tree;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SingleExampleExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.PredictionModel;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.AdditionalInformation;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.RegressionTreeNode;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.RegressionTreePainter;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.SimpleTreeNodePainter;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.TreeNode;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegressionTreeModel
extends PredictionModel {
    private TreeNode root;

    public RegressionTreeModel(Attribute labelAttribute, TreeNode root) {
        super(labelAttribute);
        this.root = root;
    }

    @Override
    public void performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        for (Example example : exampleSet) {
            SingleExampleExampleSet singularSet = new SingleExampleExampleSet((ExampleSet)exampleSet.clone(), example);
            this.predict(singularSet, this.root, predictedLabel);
        }
    }

    private void predict(ExampleSet singularSet, TreeNode node, Attribute tmpPredAtt) throws OperatorException {
        Example example = singularSet.getExample(0);
        Iterator<TreeNode> childIterator = node.childIterator();
        while (childIterator.hasNext()) {
            TreeNode currentChild = childIterator.next();
            if (!currentChild.getNodeCondition().testExample(example)) continue;
            this.predict(singularSet, currentChild, tmpPredAtt);
            break;
        }
        if (!node.hasChildren()) {
            ((RegressionTreeNode)node).getRegressionModel().apply(singularSet);
            double prediction = example.getValue(singularSet.getAttributes().getPredictedLabel());
            example.setValue(tmpPredAtt, prediction);
            PredictionModel.removePredictedLabel(singularSet);
        }
    }

    @Override
    public Component getVisualizationComponent(IOContainer container) {
        return new JScrollPane(new RegressionTreePainter(this.root, new SimpleTreeNodePainter()));
    }

    @Override
    public String toString() {
        ArrayList<Model> modelList = new ArrayList<Model>();
        StringBuffer buffer = this.toString(this.root, "|   ", new StringBuffer(), modelList);
        buffer.append("\n\nModels:\n");
        buffer.append("=======\n");
        int index = 0;
        for (Model model : modelList) {
            buffer.append("Model " + ++index);
            buffer.append("\n");
            buffer.append(model.toString());
            buffer.append("\n\n");
        }
        return buffer.toString();
    }

    private StringBuffer toString(TreeNode node, String indent, StringBuffer buffer, ArrayList<Model> modelList) {
        buffer.append(node.getNodeCondition().toString());
        if (node.hasChildren()) {
            Iterator<TreeNode> childIterator = node.childIterator();
            while (childIterator.hasNext()) {
                buffer.append("\n");
                buffer.append(indent);
                TreeNode childNode = childIterator.next();
                this.toString(childNode, String.valueOf(indent) + "|   ", buffer, modelList);
            }
        } else {
            buffer.append(": ");
            modelList.add(((RegressionTreeNode)node).getRegressionModel());
            buffer.append("Model " + modelList.size());
            for (AdditionalInformation a : node.getAdditionalGraphics()) {
                buffer.append("   ");
                buffer.append(a.toString());
            }
        }
        return buffer;
    }

    @Override
    public void initWriting() {
        this.deleteTrainExampleSets(this.root);
    }

    private void deleteTrainExampleSets(TreeNode node) {
        Iterator<TreeNode> iterator = node.childIterator();
        while (iterator.hasNext()) {
            this.deleteTrainExampleSets(iterator.next());
        }
        node.removeTrainExampleSet();
    }
}

