/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.splitLearner.tree;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.InputDescription;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.LastInnerOperatorCondition;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.RegressionTreeLearner;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegressionTreeLearnerChain
extends OperatorChain {
    private RegressionTreeLearner learner;

    public RegressionTreeLearnerChain(OperatorDescription description) {
        super(description);
        this.learner = new RegressionTreeLearner(description, this);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        return new IOObject[]{this.learner.learn(exampleSet)};
    }

    @Override
    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    public Model estimateRegressionModel(ExampleSet set) {
        try {
            IOContainer input = new IOContainer(new IOObject[]{set});
            int i = 0;
            while (i < this.getNumberOfOperators()) {
                input = this.getOperator(i).apply(input);
                ++i;
            }
            return input.get(Model.class);
        }
        catch (OperatorException e) {
            return null;
        }
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[]{Model.class});
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{Model.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeInt("min_set_size", "minimal size a set must have to be splitted", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("c", "weight of complexity in tree pruning", 0.0, 1.0, 0.1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean("no_pruning", "disables the pruning", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

