/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.splitLearner.tree;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.splitLearner.EmptySplitCondition;
import edu.udo.cs.yale.operator.learner.splitLearner.SimpleAttributeManager;
import edu.udo.cs.yale.operator.learner.splitLearner.Split;
import edu.udo.cs.yale.operator.learner.splitLearner.SplitCondition;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.AbstractTreeLearner;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.LazyTreePruner;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.RegressionPruner;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.RegressionSplitter;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.RegressionTreeLearnerChain;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.RegressionTreeModel;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.RegressionTreeNode;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.SimpleRegressionPrePruner;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.TreeNode;
import java.util.ArrayList;
import java.util.List;

public class RegressionTreeLearner
extends AbstractTreeLearner {
    private RegressionTreeLearnerChain chain;
    private int numberOfModels = 1;

    public RegressionTreeLearner(OperatorDescription description) {
        super(description);
    }

    public RegressionTreeLearner(OperatorDescription description, RegressionTreeLearnerChain chain) {
        super(description);
        this.chain = chain;
    }

    public TreeNode constructNode(ExampleSet exampleSet, SplitCondition condition) {
        return new RegressionTreeNode(condition, exampleSet);
    }

    public void init(ExampleSet exampleSet) throws OperatorException {
        this.root = new RegressionTreeNode(new EmptySplitCondition(), exampleSet);
        this.pruner = this.chain.getParameterAsBoolean("no_pruning") ? new LazyTreePruner() : new RegressionPruner(this.chain.getParameterAsDouble("c"), this.chain, this);
        this.prePruner = new SimpleRegressionPrePruner(this.chain.getParameterAsInt("min_set_size"), 0.0);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (Attribute currentAttribute : exampleSet.getAttributes()) {
            attributes.add(currentAttribute);
        }
        this.attributeManager = new SimpleAttributeManager((List<Attribute>)attributes);
        this.splitter = new RegressionSplitter(null, this.chain.getParameterAsInt("min_set_size"));
    }

    protected void setLabel(TreeNode node, Attribute labelAttribute, double labelValue, ExampleSet leafSet) {
        RegressionTreeNode regressionNode = (RegressionTreeNode)node;
        regressionNode.setRegressionModel(this.chain.estimateRegressionModel(leafSet));
        regressionNode.setStringLabel("Regression Model");
        ++this.numberOfModels;
    }

    public Model learn(ExampleSet exampleSet) throws OperatorException {
        this.init(exampleSet);
        this.labelAttribute = exampleSet.getAttributes().getLabel();
        this.attributeManager.reset();
        if (this.attributeManager.hasNext()) {
            Split firstSplit = this.splitter.getBestSplit(exampleSet, this.attributeManager);
            this.buildModel(exampleSet, this.root, this.attributeManager, firstSplit);
            this.pruner.prune(this.root);
        }
        return new RegressionTreeModel(this.labelAttribute, this.root);
    }
}

