/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.splitLearner.tree;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.splitLearner.EmptySplitCondition;
import edu.udo.cs.yale.operator.learner.splitLearner.GainRatioCriterion;
import edu.udo.cs.yale.operator.learner.splitLearner.RandomAttributeManager;
import edu.udo.cs.yale.operator.learner.splitLearner.SimpleSplitter;
import edu.udo.cs.yale.operator.learner.splitLearner.SplitCondition;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.AbstractTreeLearner;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.LazyTreePruner;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.SimplePrePruner;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.SimpleTreeNode;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.TreeNode;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomTreeLearner
extends AbstractTreeLearner {
    public RandomTreeLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public TreeNode constructNode(ExampleSet exampleSet, SplitCondition condition) {
        return new SimpleTreeNode(condition);
    }

    @Override
    public void init(ExampleSet exampleSet) throws OperatorException {
        this.root = new SimpleTreeNode(new EmptySplitCondition());
        this.pruner = new LazyTreePruner();
        this.prePruner = new SimplePrePruner(this.getParameterAsInt("min_set_size"), 0.0);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (Attribute currentAttribute : exampleSet.getAttributes()) {
            attributes.add(currentAttribute);
        }
        this.attributeManager = new RandomAttributeManager((List<Attribute>)attributes, this.getParameterAsInt("attribute_set_size"));
        this.splitter = new SimpleSplitter(new GainRatioCriterion());
    }

    @Override
    public boolean supportsCapability(LearnerCapability capability) {
        if (capability == LearnerCapability.BINOMINAL_ATTRIBUTES) {
            return true;
        }
        if (capability == LearnerCapability.POLYNOMINAL_ATTRIBUTES) {
            return true;
        }
        if (capability == LearnerCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (capability == LearnerCapability.POLYNOMINAL_CLASS) {
            return true;
        }
        return capability == LearnerCapability.NUMERICAL_CLASS;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("min_set_size", "minimal size a set must have to be splitted", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("attribute_set_size", "number of randomly chosen attributes to test", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

