/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.splitLearner.tree;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.SimplePredictionModel;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.TreeModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JTabbedPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForestModel
extends SimplePredictionModel {
    private ArrayList<TreeModel> models;

    public ForestModel(Attribute labelAttribute, ArrayList<TreeModel> models) {
        super(labelAttribute);
        this.models = models;
    }

    @Override
    public double predict(Example example) throws OperatorException {
        TreeMap<Double, Integer> classVotes = new TreeMap<Double, Integer>();
        Iterator<TreeModel> iterator = this.models.iterator();
        while (iterator.hasNext()) {
            double vote = iterator.next().predict(example);
            if (classVotes.containsKey(vote)) {
                classVotes.put(vote, (Integer)classVotes.get(vote) + 1);
                continue;
            }
            classVotes.put(vote, 1);
        }
        Iterator votedClasses = classVotes.keySet().iterator();
        double bestClass = Double.NaN;
        int bestClassesVotes = Integer.MIN_VALUE;
        while (votedClasses.hasNext()) {
            double currentClass = (Double)votedClasses.next();
            int currentVotes = (Integer)classVotes.get(currentClass);
            if (currentVotes <= bestClassesVotes) continue;
            bestClass = currentClass;
            bestClassesVotes = currentVotes;
        }
        return bestClass;
    }

    @Override
    public Component getVisualizationComponent(IOContainer container) {
        JTabbedPane tabPane = new JTabbedPane();
        int index = 1;
        for (TreeModel model : this.models) {
            tabPane.add("Model " + index, model.getVisualizationComponent(container));
            ++index;
        }
        return tabPane;
    }

    @Override
    public void initWriting() {
        for (TreeModel model : this.models) {
            model.initWriting();
        }
    }
}

