/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.splitLearner.tree;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.splitLearner.EmptySplitCondition;
import edu.udo.cs.yale.operator.learner.splitLearner.GainRatioCriterion;
import edu.udo.cs.yale.operator.learner.splitLearner.SimpleAttributeManager;
import edu.udo.cs.yale.operator.learner.splitLearner.SimpleSplitter;
import edu.udo.cs.yale.operator.learner.splitLearner.SplitCondition;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.AbstractTreeLearner;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.DecisionStumpPrePruner;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.LazyTreePruner;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.SimpleTreeNode;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.TreeNode;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeNumber;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionStumpLearner
extends AbstractTreeLearner {
    public DecisionStumpLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public TreeNode constructNode(ExampleSet exampleSet, SplitCondition condition) {
        return new SimpleTreeNode(condition);
    }

    @Override
    public void init(ExampleSet exampleSet) throws OperatorException {
        this.root = new SimpleTreeNode(new EmptySplitCondition());
        this.pruner = new LazyTreePruner();
        this.prePruner = new DecisionStumpPrePruner();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (Attribute currentAttribute : exampleSet.getAttributes()) {
            attributes.add(currentAttribute);
        }
        this.attributeManager = new SimpleAttributeManager((List<Attribute>)attributes);
        this.splitter = new SimpleSplitter(new GainRatioCriterion());
    }

    @Override
    public boolean supportsCapability(LearnerCapability capability) {
        if (capability == LearnerCapability.BINOMINAL_ATTRIBUTES) {
            return true;
        }
        if (capability == LearnerCapability.POLYNOMINAL_ATTRIBUTES) {
            return true;
        }
        if (capability == LearnerCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (capability == LearnerCapability.POLYNOMINAL_CLASS) {
            return true;
        }
        return capability == LearnerCapability.NUMERICAL_CLASS;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeInt("min_set_size", "minimal size a set must have to be splitted", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("min_gain", "minimal splitbenefit a split must provide to be executed", 0.0, Double.MAX_VALUE, 0.025);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

