/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.splitLearner.tree;

import edu.udo.cs.yale.gui.plotter.PlotterAdapter;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.AdditionalInformation;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class ClassNumberInformation
implements AdditionalInformation {
    private static final int HEIGHT = 14;
    private int[] classNumbers;
    double[] perClassProportion;

    public ClassNumberInformation(int[] classNumbers, int numberOfExamples) {
        this.classNumbers = classNumbers;
        this.perClassProportion = new double[classNumbers.length];
        int currentNumber = numberOfExamples;
        int i = 0;
        while (i < classNumbers.length) {
            this.perClassProportion[i] = (double)classNumbers[i] / (double)currentNumber;
            currentNumber -= classNumbers[i];
            ++i;
        }
    }

    public int getMinHeight(Graphics2D graphics) {
        return 14;
    }

    public int getMinWidth(Graphics2D graphics) {
        Rectangle2D bounds = graphics.getFont().getStringBounds(this.getClassNumbers(), graphics.getFontRenderContext());
        return (int)bounds.getWidth();
    }

    public void paint(Graphics2D graphics, int width, int height) {
        int leftWidth = width;
        int[] perClassWidth = new int[this.classNumbers.length];
        int i = 0;
        while (i < this.classNumbers.length) {
            perClassWidth[i] = (int)Math.round(this.perClassProportion[i] * (double)leftWidth);
            if (this.perClassProportion[i] > 0.0 && perClassWidth[i] == 0) {
                perClassWidth[i] = 1;
            }
            leftWidth -= perClassWidth[i];
            ++i;
        }
        double currentOffsetX = 0.0;
        int i2 = 0;
        while (i2 < this.classNumbers.length) {
            Rectangle2D.Double classRect = new Rectangle2D.Double(currentOffsetX, 0.0, perClassWidth[i2], 14.0);
            graphics.setColor(PlotterAdapter.getPointColor((double)i2 / (double)(this.classNumbers.length - 1)));
            graphics.fill(classRect);
            currentOffsetX += (double)perClassWidth[i2];
            ++i2;
        }
        graphics.setColor(SwingTools.LIGHTEST_BLUE);
        graphics.drawString(this.getClassNumbers(), 2, 11);
        graphics.setColor(SwingTools.DARK_BLUE);
        graphics.drawRect(0, 0, width, 14);
    }

    public int[] getClassFrequencies() {
        return this.classNumbers;
    }

    private String getClassNumbers() {
        StringBuffer buffer = new StringBuffer("(");
        int i = 0;
        while (i < this.classNumbers.length) {
            if (i != 0) {
                buffer.append("/");
            }
            buffer.append(this.classNumbers[i]);
            ++i;
        }
        buffer.append(")");
        return buffer.toString();
    }

    public String toString() {
        return this.getClassNumbers();
    }
}

