/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.splitLearner.tree;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.NominalAttributeStatistics;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.AbstractLearner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.splitLearner.AttributeManager;
import edu.udo.cs.yale.operator.learner.splitLearner.Split;
import edu.udo.cs.yale.operator.learner.splitLearner.SplitCondition;
import edu.udo.cs.yale.operator.learner.splitLearner.Splitter;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.ClassNumberInformation;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.TreeModel;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.TreeNode;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.TreePrePruner;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.TreePruner;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractTreeLearner
extends AbstractLearner {
    protected TreeNode root;
    protected TreePrePruner prePruner;
    protected TreePruner pruner;
    protected Splitter splitter;
    protected AttributeManager attributeManager;
    protected Attribute labelAttribute;

    public AbstractTreeLearner(OperatorDescription description) {
        super(description);
    }

    public Model learn(ExampleSet exampleSet) throws OperatorException {
        this.init(exampleSet);
        this.labelAttribute = exampleSet.getAttributes().getLabel();
        this.attributeManager.reset();
        if (this.attributeManager.hasNext()) {
            Split firstSplit = this.splitter.getBestSplit(exampleSet, this.attributeManager);
            this.buildModel(exampleSet, this.root, this.attributeManager, firstSplit);
            this.pruner.prune(this.root);
        }
        return new TreeModel(this.labelAttribute, this.root);
    }

    public boolean supportsCapability(LearnerCapability capability) {
        return false;
    }

    public abstract void init(ExampleSet var1) throws OperatorException;

    public abstract TreeNode constructNode(ExampleSet var1, SplitCondition var2);

    protected void buildModel(ExampleSet exampleSet, TreeNode currentNode, AttributeManager attributeManager, Split split) {
        Map<ExampleSet, SplitCondition> splittedSets = this.splitter.split(exampleSet, attributeManager, split);
        for (Map.Entry<ExampleSet, SplitCondition> entry : splittedSets.entrySet()) {
            ExampleSet currentSet = entry.getKey();
            TreeNode childNode = this.constructNode(currentSet, entry.getValue());
            currentNode.addChild(childNode);
            attributeManager.reset();
            if (!this.prePruner.prePrune(currentSet) && attributeManager.hasNext()) {
                Split currentSplit = null;
                if (!this.prePruner.prePrune(currentSet)) {
                    currentSplit = this.splitter.getBestSplit(currentSet, attributeManager);
                    if (!this.prePruner.prePrune(currentSet, currentSplit)) {
                        this.buildModel(currentSet, childNode, attributeManager.clone(), currentSplit);
                        continue;
                    }
                    this.setLabel(childNode, this.labelAttribute, this.prePruner.prePrunedLabel(currentSet), currentSet);
                    continue;
                }
                this.setLabel(childNode, this.labelAttribute, this.prePruner.prePrunedLabel(currentSet), currentSet);
                continue;
            }
            this.setLabel(childNode, this.labelAttribute, this.prePruner.prePrunedLabel(currentSet), currentSet);
        }
    }

    protected void setLabel(TreeNode node, Attribute labelAttribute, double labelValue, ExampleSet leafSet) {
        node.setLabel(labelValue);
        node.setStringLabel(labelAttribute.getAsString(labelValue, 2));
        node.pruneChildren();
        leafSet.recalculateAttributeStatistics(labelAttribute);
        Iterator<String> iterator = labelAttribute.getMapping().getValues().iterator();
        int[] classNumbers = new int[labelAttribute.getMapping().size()];
        int i = 0;
        while (iterator.hasNext()) {
            String currentLabel = iterator.next();
            classNumbers[i] = ((NominalAttributeStatistics)labelAttribute.getStatistics()).getValueCount(currentLabel);
            ++i;
        }
        node.addAdditionalGraphic(new ClassNumberInformation(classNumbers, leafSet.size()));
    }
}

