/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.splitLearner.rules;

import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.operator.learner.splitLearner.AbstractSplitCondition;
import edu.udo.cs.yale.operator.learner.splitLearner.SplitCondition;
import java.util.ArrayList;

public class Rule
extends AbstractSplitCondition {
    private ArrayList<SplitCondition> terms;
    private double labelValue;
    private String labelName;

    public Rule(double labelValue, String labelName) {
        this.labelName = labelName;
        this.labelValue = labelValue;
        this.terms = new ArrayList();
    }

    public Rule(double labelValue, String labelName, SplitCondition term) {
        this.labelName = labelName;
        this.labelValue = labelValue;
        this.terms = new ArrayList();
        this.terms.add(term);
    }

    public boolean testExample(Example example) {
        boolean result = true;
        for (SplitCondition term : this.terms) {
            result &= term.testExample(example);
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("if ");
        boolean firstTerm = true;
        for (SplitCondition condition : this.terms) {
            if (!firstTerm) {
                buffer.append(" and ");
            }
            buffer.append(condition.toString());
            firstTerm = false;
        }
        buffer.append(" then ");
        buffer.append(this.labelName);
        return buffer.toString();
    }

    public void addTerm(SplitCondition condition) {
        this.terms.add(condition);
    }

    public double getLabel() {
        return this.labelValue;
    }
}

