/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.splitLearner;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.learner.splitLearner.AttributeManager;
import edu.udo.cs.yale.operator.learner.splitLearner.NominalSplitter;
import edu.udo.cs.yale.operator.learner.splitLearner.Split;
import edu.udo.cs.yale.operator.learner.splitLearner.SplitCondition;
import edu.udo.cs.yale.operator.learner.splitLearner.SplitCriterion;
import edu.udo.cs.yale.operator.learner.splitLearner.SplitPartition;
import edu.udo.cs.yale.operator.learner.splitLearner.SplitTripel;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.GreaterEqualNodeCondition;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.LessNodeCondition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class SimpleSplitter
extends NominalSplitter {
    public SimpleSplitter(SplitCriterion criterion) {
        super(criterion);
    }

    public Split getBestSplit(ExampleSet exampleSet, AttributeManager attributeManager) {
        int numberOfLabels = this.getNumberOfLabels(exampleSet);
        int[] labels = this.getLabelArray(exampleSet);
        Split bestSplit = super.getBestSplit(exampleSet, attributeManager, labels, numberOfLabels);
        attributeManager.reset();
        while (attributeManager.hasNext()) {
            Attribute currentAttribute = attributeManager.next();
            if (currentAttribute.isNominal()) continue;
            int i = 0;
            Object[] valueLabelPositions = new SplitTripel[exampleSet.size()];
            Iterator exampleIterator = exampleSet.iterator();
            while (exampleIterator.hasNext()) {
                double currentValue = ((Example)exampleIterator.next()).getValue(currentAttribute);
                valueLabelPositions[i] = new SplitTripel(currentValue, labels[i], i);
                ++i;
            }
            int numberOfExamples = i;
            Arrays.sort(valueLabelPositions);
            int[] currentFrequency = new int[numberOfLabels];
            ArrayList<SplitPartition> splitPoints = new ArrayList<SplitPartition>((int)Math.sqrt(valueLabelPositions.length) * numberOfLabels);
            int lastClass = ((SplitTripel)valueLabelPositions[0]).getLabel();
            i = 0;
            while (i < valueLabelPositions.length - 1) {
                int currentLabel = ((SplitTripel)valueLabelPositions[i]).getLabel();
                if (lastClass != currentLabel) {
                    int[] newFrequency = new int[currentFrequency.length];
                    System.arraycopy(currentFrequency, 0, newFrequency, 0, currentFrequency.length);
                    splitPoints.add(new SplitPartition(newFrequency, i, (((SplitTripel)valueLabelPositions[i]).getValue() + ((SplitTripel)valueLabelPositions[i - 1]).getValue()) / 2.0));
                    lastClass = currentLabel;
                }
                int n = currentLabel;
                currentFrequency[n] = currentFrequency[n] + 1;
                ++i;
            }
            int n = ((SplitTripel)valueLabelPositions[valueLabelPositions.length - 1]).getLabel();
            currentFrequency[n] = currentFrequency[n] + 1;
            int[] totalClassFrequency = currentFrequency;
            for (SplitPartition currentPoint : splitPoints) {
                int[] leftSide = currentPoint.getClassFrequencies();
                int[] rightSide = new int[numberOfLabels];
                i = 0;
                while (i < numberOfLabels) {
                    rightSide[i] = totalClassFrequency[i] - leftSide[i];
                    ++i;
                }
                ArrayList<SplitPartition> partitionList = new ArrayList<SplitPartition>(2);
                partitionList.add(currentPoint);
                partitionList.add(new SplitPartition(rightSide, numberOfExamples - currentPoint.getNumberOfExamples(), 0.0));
                double valueBenefit = this.criterion.getSplitBenefit(partitionList, new SplitPartition(totalClassFrequency, numberOfExamples, 0.0));
                if (!bestSplit.testSplit(valueBenefit)) continue;
                int[] partitionIndices = new int[exampleSet.size()];
                Arrays.fill(partitionIndices, currentPoint.getNumberOfExamples(), partitionIndices.length, 1);
                ArrayList<SplitCondition> conditions = new ArrayList<SplitCondition>(2);
                conditions.add(new LessNodeCondition(currentAttribute, currentPoint.getSplitValue()));
                conditions.add(new GreaterEqualNodeCondition(currentAttribute, currentPoint.getSplitValue()));
                bestSplit.setSplit(currentAttribute, true, valueBenefit, partitionIndices, (SplitTripel[])valueLabelPositions, 2, conditions);
            }
        }
        return bestSplit;
    }
}

