/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.splitLearner;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.operator.learner.splitLearner.AttributeManager;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomAttributeManager
implements AttributeManager {
    private ArrayList<Attribute> useAttributes = new ArrayList();
    private LinkedList<Attribute> selectedAttributes = new LinkedList();
    private Iterator<Attribute> iterator;
    private int numberOfSelections;

    public RandomAttributeManager(Collection<Attribute> attributes, int numberOfSelections) {
        this.numberOfSelections = numberOfSelections;
        Iterator<Attribute> iterator = attributes.iterator();
        while (iterator.hasNext()) {
            this.useAttributes.add(iterator.next());
        }
    }

    public RandomAttributeManager(List<Attribute> list, int numberOfSelections) {
        this.useAttributes.addAll(list);
        this.numberOfSelections = numberOfSelections;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Attribute next() {
        return this.iterator.next();
    }

    @Override
    public void useAttribute(Attribute attribute) {
        this.useAttributes.remove(attribute);
    }

    @Override
    public void reset() {
        this.selectedAttributes = new LinkedList<Attribute>(this.useAttributes);
        while (this.selectedAttributes.size() > this.numberOfSelections) {
            int nextInt = 0;
            try {
                nextInt = RandomGenerator.getGlobalRandomGenerator().nextIntInRange(0, this.selectedAttributes.size() - 1);
                this.selectedAttributes.remove(nextInt);
            }
            catch (Exception e) {
                System.out.println(nextInt);
            }
        }
        this.iterator = this.selectedAttributes.iterator();
    }

    @Override
    public AttributeManager clone() {
        return new RandomAttributeManager((List<Attribute>)this.useAttributes, this.numberOfSelections);
    }
}

