/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.splitLearner;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.Partition;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.learner.splitLearner.Split;
import edu.udo.cs.yale.operator.learner.splitLearner.SplitCondition;
import edu.udo.cs.yale.operator.learner.splitLearner.SplitTripel;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericalSplit
implements Split {
    private Attribute splitAttribute;
    private int[] splitPartition;
    private SplitTripel[] valueLabelPositions;
    private int numberOfPartitions;
    private double splitBenefit = Double.NEGATIVE_INFINITY;
    private boolean reUseAttribue;
    private ArrayList<SplitCondition> conditions;

    private int[] getSplitPartition() {
        if (this.valueLabelPositions != null) {
            int[] reorderedPartition = new int[this.splitPartition.length];
            int i = 0;
            while (i < this.splitPartition.length) {
                reorderedPartition[this.valueLabelPositions[i].getPosition()] = this.splitPartition[i];
                ++i;
            }
            return reorderedPartition;
        }
        return this.splitPartition;
    }

    @Override
    public SplittedExampleSet getSplittedExampleSet(ExampleSet exampleSet) {
        if (this.splitPartition != null) {
            Partition splitPartition = new Partition(this.getSplitPartition(), this.numberOfPartitions);
            return new SplittedExampleSet(exampleSet, (Partition)splitPartition.clone());
        }
        return null;
    }

    @Override
    public int getNumberOfSplitPartitions() {
        return this.numberOfPartitions;
    }

    @Override
    public Attribute getSplitAttribute() {
        return this.splitAttribute;
    }

    @Override
    public double getSplitBenefit() {
        return this.splitBenefit;
    }

    @Override
    public ArrayList<SplitCondition> getSplitConditions() {
        return this.conditions;
    }

    @Override
    public boolean reUseAttribute() {
        return this.reUseAttribue;
    }

    @Override
    public void setSplit(Attribute splitAttribute, boolean reUseAttribute, double splitBenefit, int[] splitPartition, SplitTripel[] valueLabelPositions, int numberOfPartitions, ArrayList<SplitCondition> conditions) {
        this.splitAttribute = splitAttribute;
        this.splitBenefit = splitBenefit;
        this.splitPartition = (int[])splitPartition.clone();
        if (valueLabelPositions != null) {
            this.valueLabelPositions = (SplitTripel[])valueLabelPositions.clone();
        }
        this.numberOfPartitions = numberOfPartitions;
        this.conditions = conditions;
        this.reUseAttribue = reUseAttribute;
    }

    @Override
    public boolean testSplit(double splitBenefit) {
        return this.splitBenefit < splitBenefit;
    }
}

