/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.splitLearner;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.learner.splitLearner.AbstractSplitter;
import edu.udo.cs.yale.operator.learner.splitLearner.AttributeManager;
import edu.udo.cs.yale.operator.learner.splitLearner.NumericalSplit;
import edu.udo.cs.yale.operator.learner.splitLearner.Split;
import edu.udo.cs.yale.operator.learner.splitLearner.SplitCondition;
import edu.udo.cs.yale.operator.learner.splitLearner.SplitCriterion;
import edu.udo.cs.yale.operator.learner.splitLearner.SplitPartition;
import edu.udo.cs.yale.operator.learner.splitLearner.tree.EqualNodeCondition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class NominalSplitter
extends AbstractSplitter {
    public NominalSplitter(SplitCriterion criterion) {
        this.criterion = criterion;
    }

    public Split getBestSplit(ExampleSet exampleSet, AttributeManager attributeManager) {
        int numberOfLabels = this.getNumberOfLabels(exampleSet);
        int[] labels = this.getLabelArray(exampleSet);
        return this.getBestSplit(exampleSet, attributeManager, labels, numberOfLabels);
    }

    protected Split getBestSplit(ExampleSet exampleSet, AttributeManager attributeManager, int[] labels, int numberOfLabels) {
        NumericalSplit bestSplit = new NumericalSplit();
        attributeManager.reset();
        while (attributeManager.hasNext()) {
            Attribute currentAttribute = attributeManager.next();
            Iterator exampleIterator = exampleSet.iterator();
            if (!currentAttribute.isNominal()) continue;
            int[][] partitionClassFrequencies = new int[currentAttribute.getMapping().size()][numberOfLabels];
            int[] partitionFrequencies = new int[currentAttribute.getMapping().size()];
            int[] totalClassFrequencies = new int[numberOfLabels];
            int[] partitionIndices = new int[exampleSet.size()];
            LinkedHashMap<Double, Integer> partitionMapping = new LinkedHashMap<Double, Integer>();
            int i = 0;
            while (exampleIterator.hasNext()) {
                int currentPartition;
                Example currentExample = (Example)exampleIterator.next();
                double currentValue = currentExample.getValue(currentAttribute);
                int currentLabel = (int)currentExample.getLabel();
                if (partitionMapping.containsKey(currentValue)) {
                    currentPartition = (Integer)partitionMapping.get(currentValue);
                } else {
                    currentPartition = partitionMapping.size();
                    partitionMapping.put(currentValue, partitionMapping.size());
                }
                partitionIndices[i] = currentPartition;
                int n = currentPartition;
                partitionFrequencies[n] = partitionFrequencies[n] + 1;
                int[] nArray = partitionClassFrequencies[currentPartition];
                int n2 = currentLabel;
                nArray[n2] = nArray[n2] + 1;
                int n3 = currentLabel;
                totalClassFrequencies[n3] = totalClassFrequencies[n3] + 1;
                ++i;
            }
            int numberOfExamples = i;
            int numberOfPartitions = partitionMapping.size();
            ArrayList<SplitPartition> partitions = new ArrayList<SplitPartition>(partitionClassFrequencies.length);
            i = 0;
            while (i < partitionClassFrequencies.length) {
                if (!Arrays.equals(partitionClassFrequencies[i], new int[numberOfLabels])) {
                    int[] partitionClassFrequenciesCopy = new int[partitionClassFrequencies[i].length];
                    System.arraycopy(partitionClassFrequencies[i], 0, partitionClassFrequenciesCopy, 0, partitionClassFrequencies[i].length);
                    partitions.add(new SplitPartition(partitionClassFrequenciesCopy, partitionFrequencies[i], 0.0));
                }
                ++i;
            }
            double benefit = this.criterion.getSplitBenefit(partitions, new SplitPartition(totalClassFrequencies, numberOfExamples, 0.0));
            if (!bestSplit.testSplit(benefit)) continue;
            ArrayList<SplitCondition> conditions = new ArrayList<SplitCondition>();
            Iterator iterator = partitionMapping.keySet().iterator();
            while (iterator.hasNext()) {
                double value = (Double)iterator.next();
                conditions.add(new EqualNodeCondition(currentAttribute, value));
            }
            bestSplit.setSplit(currentAttribute, false, benefit, partitionIndices, null, numberOfPartitions, conditions);
        }
        return bestSplit;
    }

    protected int[] getLabelArray(ExampleSet exampleSet) {
        int[] labels = new int[exampleSet.size()];
        Iterator exampleIterator = exampleSet.iterator();
        Attribute label = exampleSet.getAttributes().getLabel();
        int i = 0;
        while (exampleIterator.hasNext()) {
            labels[i] = (int)((Example)exampleIterator.next()).getValue(label);
            ++i;
        }
        return labels;
    }

    protected int getNumberOfLabels(ExampleSet exampleSet) {
        return exampleSet.getAttributes().getLabel().getMapping().size();
    }
}

