/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.splitLearner;

import edu.udo.cs.yale.operator.learner.splitLearner.SplitCriterion;
import edu.udo.cs.yale.operator.learner.splitLearner.SplitPartition;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InformationGainCriterion
implements SplitCriterion {
    private double logFactor = 1.0 / Math.log(2.0);

    @Override
    public double getSplitBenefit(Collection<SplitPartition> partitions, SplitPartition total) {
        double info = this.getEntropy(total);
        double gain = 0.0;
        int numberOfExamples = total.getNumberOfExamples();
        for (SplitPartition currentPartition : partitions) {
            gain += this.getEntropy(currentPartition) * (double)currentPartition.getNumberOfExamples() / (double)numberOfExamples;
        }
        return info - gain;
    }

    protected double getEntropy(SplitPartition frequencies) {
        int[] classCounter = frequencies.getClassFrequencies();
        double numberOfExamples = frequencies.getNumberOfExamples();
        double entropy = 0.0;
        int i = 0;
        while (i < classCounter.length) {
            if (classCounter[i] > 0) {
                double proportion = (double)classCounter[i] / numberOfExamples;
                entropy -= Math.log(proportion) * this.logFactor * proportion;
            }
            ++i;
        }
        return entropy;
    }
}

