/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.splitLearner;

import edu.udo.cs.yale.operator.learner.splitLearner.InformationGainCriterion;
import edu.udo.cs.yale.operator.learner.splitLearner.SplitCriterion;
import edu.udo.cs.yale.operator.learner.splitLearner.SplitPartition;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GainRatioCriterion
extends InformationGainCriterion
implements SplitCriterion {
    private double logFactor = Math.log(2.0);

    @Override
    public double getSplitBenefit(Collection<SplitPartition> partitions, SplitPartition total) {
        double entropy = super.getSplitBenefit(partitions, total);
        return entropy / this.getSplitInfo(partitions, total);
    }

    protected double getSplitInfo(Collection<SplitPartition> partitions, SplitPartition total) {
        double numberOfExamples = total.getNumberOfExamples();
        double splitInfo = 0.0;
        for (SplitPartition currentPartition : partitions) {
            double partitionProportion = (double)currentPartition.getNumberOfExamples() / numberOfExamples;
            splitInfo -= partitionProportion * Math.log(partitionProportion) * this.logFactor;
        }
        return splitInfo;
    }
}

