/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.neuralnet;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.learner.AbstractLearner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.neuralnet.NeuralNetModel;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.tools.LogService;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.joone.engine.FullSynapse;
import org.joone.engine.GaussianLayer;
import org.joone.engine.InputPatternListener;
import org.joone.engine.Layer;
import org.joone.engine.LinearLayer;
import org.joone.engine.LogarithmicLayer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.SineLayer;
import org.joone.engine.TanhLayer;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.engine.listeners.ErrorBasedTerminator;
import org.joone.io.MemoryInputSynapse;
import org.joone.io.MemoryOutputSynapse;
import org.joone.io.StreamInputSynapse;
import org.joone.net.NeuralNet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeuralNetLearner
extends AbstractLearner
implements NeuralNetListener {
    private static final String[] LAYER_TYPES = new String[]{"linear", "sigmoid", "tanh", "sine", "logarithmic", "gaussian"};
    private static final int LINEAR = 0;
    private static final int SIGMOID = 1;
    private static final int TANH = 2;
    private static final int SINE = 3;
    private static final int LOGARITHMIC = 4;
    private static final int GAUSSIAN = 5;
    private NeuralNet neuralNet;
    private MemoryInputSynapse inputSynapse;
    private MemoryInputSynapse desiredOutputSynapse;
    private double minLabel;
    private double maxLabel;

    public NeuralNetLearner(OperatorDescription description) {
        super(description);
    }

    private int getDefaultLayerSize(ExampleSet exampleSet) {
        return (int)Math.round((double)exampleSet.getAttributes().size() / 2.0) + 1;
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label.isNominal() && label.getMapping().size() != 2) {
            throw new UserError((Operator)this, 114, this.getName(), (Object)label.getName());
        }
        this.initNeuralNet(exampleSet);
        this.train(exampleSet);
        return new NeuralNetModel(label, this.neuralNet, exampleSet.getAttributes().size(), this.minLabel, this.maxLabel);
    }

    private Layer createLayer(String layerTypeName, int size, int counter) {
        return this.createLayer("Hidden", layerTypeName, size, counter);
    }

    private Layer createLayer(String layerName, String layerTypeName, int size, int counter) {
        LinearLayer layer = null;
        if (LAYER_TYPES[0].equals(layerTypeName.toLowerCase())) {
            layer = new LinearLayer();
        } else if (LAYER_TYPES[1].equals(layerTypeName.toLowerCase())) {
            layer = new SigmoidLayer();
        } else if (LAYER_TYPES[2].equals(layerTypeName.toLowerCase())) {
            layer = new TanhLayer();
        } else if (LAYER_TYPES[3].equals(layerTypeName.toLowerCase())) {
            layer = new SineLayer();
        } else if (LAYER_TYPES[4].equals(layerTypeName.toLowerCase())) {
            layer = new LogarithmicLayer();
        } else if (LAYER_TYPES[5].equals(layerTypeName.toLowerCase())) {
            layer = new GaussianLayer();
        } else {
            LogService.logMessage("Cannot create layer of type '" + layerTypeName + "', using sigmoid layer instead.", 4);
            layer = new SigmoidLayer();
        }
        layer.setRows(size);
        String name = layerName;
        if (counter >= 0) {
            name = String.valueOf(name) + "-" + counter;
        }
        name = String.valueOf(name) + " [" + layerTypeName + "]";
        layer.setLayerName(name);
        return layer;
    }

    private void initNeuralNet(ExampleSet exampleSet) throws UndefinedParameterError {
        Layer input = this.createLayer("Input", LAYER_TYPES[this.getParameterAsInt("input_layer_type")], exampleSet.getAttributes().size(), -1);
        Layer output = this.createLayer("Output", LAYER_TYPES[this.getParameterAsInt("output_layer_type")], 1, -1);
        LinkedList<Layer> allHiddenLayers = new LinkedList<Layer>();
        List hiddenLayerList = this.getParameterList("hidden_layer_types");
        Iterator i = hiddenLayerList.iterator();
        int counter = 1;
        while (i.hasNext()) {
            Object[] typeSizePair = (Object[])i.next();
            String layerType = (String)typeSizePair[0];
            Integer layerSizeObject = (Integer)typeSizePair[1];
            int layerSize = layerSizeObject;
            if (layerSize <= 0) {
                layerSize = this.getDefaultLayerSize(exampleSet);
            }
            Layer hiddenLayer = this.createLayer(layerType, layerSize, counter);
            allHiddenLayers.add(hiddenLayer);
            ++counter;
        }
        if (allHiddenLayers.size() == 0) {
            LogService.logMessage("No hidden layers defined. Using default hidden layers.", 2);
            String layerType = LAYER_TYPES[this.getParameterAsInt("default_hidden_layer_type")];
            int layerSize = this.getParameterAsInt("default_hidden_layer_size");
            if (layerSize <= 0) {
                layerSize = this.getDefaultLayerSize(exampleSet);
            }
            int p = 0;
            while (p < this.getParameterAsInt("default_number_of_hidden_layers")) {
                allHiddenLayers.add(this.createLayer(layerType, layerSize, p + 1));
                ++p;
            }
        }
        Layer last = null;
        for (Layer current : allHiddenLayers) {
            if (last != null) {
                FullSynapse synapse_HH = new FullSynapse();
                last.addOutputSynapse((OutputPatternListener)synapse_HH);
                current.addInputSynapse((InputPatternListener)synapse_HH);
            }
            last = current;
        }
        FullSynapse synapse_IH = new FullSynapse();
        input.addOutputSynapse((OutputPatternListener)synapse_IH);
        ((Layer)allHiddenLayers.getFirst()).addInputSynapse((InputPatternListener)synapse_IH);
        FullSynapse synapse_HO = new FullSynapse();
        ((Layer)allHiddenLayers.getLast()).addOutputSynapse((OutputPatternListener)synapse_HO);
        output.addInputSynapse((InputPatternListener)synapse_HO);
        this.inputSynapse = new MemoryInputSynapse();
        input.addInputSynapse((InputPatternListener)this.inputSynapse);
        MemoryOutputSynapse outputSynapse = new MemoryOutputSynapse();
        output.addOutputSynapse((OutputPatternListener)outputSynapse);
        TeachingSynapse trainer = new TeachingSynapse();
        this.desiredOutputSynapse = new MemoryInputSynapse();
        trainer.setDesired((StreamInputSynapse)this.desiredOutputSynapse);
        this.neuralNet = new NeuralNet();
        this.neuralNet.addLayer(input, 0);
        Iterator h = allHiddenLayers.iterator();
        while (h.hasNext()) {
            this.neuralNet.addLayer((Layer)h.next(), 1);
        }
        this.neuralNet.addLayer(output, 2);
        this.neuralNet.setTeacher(trainer);
        output.addOutputSynapse((OutputPatternListener)trainer);
        this.neuralNet.getMonitor().addNeuralNetListener((NeuralNetListener)new ErrorBasedTerminator(this.getParameterAsDouble("error_epsilon")));
    }

    public void train(ExampleSet exampleSet) throws UndefinedParameterError {
        double[][] inputArray = this.createInputData(exampleSet);
        this.inputSynapse.setInputArray(inputArray);
        this.inputSynapse.setAdvancedColumnSelector("1-" + exampleSet.getAttributes().size());
        this.desiredOutputSynapse.setInputArray(inputArray);
        this.desiredOutputSynapse.setAdvancedColumnSelector(String.valueOf(exampleSet.getAttributes().size() + 1));
        Monitor monitor = this.neuralNet.getMonitor();
        monitor.setLearningRate(this.getParameterAsDouble("learning_rate"));
        monitor.setMomentum(this.getParameterAsDouble("momentum"));
        monitor.setTrainingPatterns(inputArray.length);
        monitor.setTotCicles(this.getParameterAsInt("training_cycles"));
        monitor.setLearning(true);
        this.neuralNet.addNeuralNetListener((NeuralNetListener)this);
        this.neuralNet.start();
        this.neuralNet.getMonitor().Go();
        this.neuralNet.join();
    }

    public void cicleTerminated(NeuralNetEvent e) {
    }

    public void errorChanged(NeuralNetEvent e) {
    }

    public void netStarted(NeuralNetEvent e) {
        LogService.logMessage(String.valueOf(this.getName()) + ": learning started.", 2);
    }

    public void netStopped(NeuralNetEvent e) {
        LogService.logMessage(String.valueOf(this.getName()) + ": learning finished.", 2);
    }

    public void netStoppedError(NeuralNetEvent e, String error) {
        LogService.logMessage(String.valueOf(this.getName()) + ": learning stopped, error: " + error, 6);
    }

    private double[][] createInputData(ExampleSet exampleSet) {
        double[][] result = null;
        result = new double[exampleSet.size()][exampleSet.getAttributes().size() + 1];
        int counter = 0;
        Iterator i = exampleSet.iterator();
        this.maxLabel = Double.NEGATIVE_INFINITY;
        this.minLabel = Double.POSITIVE_INFINITY;
        Attribute label = exampleSet.getAttributes().getLabel();
        while (i.hasNext()) {
            Example example = (Example)i.next();
            int a = 0;
            for (Attribute attribute : example.getAttributes()) {
                result[counter][a++] = example.getValue(attribute);
            }
            double labelValue = example.getValue(label);
            if (label.isNominal()) {
                result[counter][exampleSet.getAttributes().size()] = (double)label.getMapping().getPositiveIndex() == labelValue ? 1.0 : 0.0;
            } else {
                result[counter][exampleSet.getAttributes().size()] = labelValue;
                this.maxLabel = Math.max(this.maxLabel, labelValue);
                this.minLabel = Math.min(this.minLabel, labelValue);
            }
            ++counter;
        }
        if (!label.isNominal()) {
            int l = 0;
            while (l < result.length) {
                result[l][exampleSet.getAttributes().size()] = (result[l][exampleSet.getAttributes().size()] - this.minLabel) / (this.maxLabel - this.minLabel);
                ++l;
            }
        }
        return result;
    }

    @Override
    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.POLYNOMINAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.BINOMINAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.BINOMINAL_CLASS) {
            return true;
        }
        return lc == LearnerCapability.NUMERICAL_CLASS;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory("input_layer_type", "The default layer type for the input layers.", LAYER_TYPES, 0));
        types.add(new ParameterTypeCategory("output_layer_type", "The default layer type for the output layers.", LAYER_TYPES, 1));
        types.add(new ParameterTypeInt("default_number_of_hidden_layers", "The number of hidden layers. Only used if no layers are defined by the list hidden_layer_types.", 1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeInt("default_hidden_layer_size", "The default size  of hidden layers. Only used if no layers are defined by the list hidden_layer_types. -1 means size (number of attributes + number of classes) / 2", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeCategory("default_hidden_layer_type", "The default layer type for the hidden layers. Only used if the parameter list hidden_layer_types is not defined.", LAYER_TYPES, 1));
        types.add(new ParameterTypeList("hidden_layer_types", "Describes the name, the size, and the type of all hidden layers", new ParameterTypeInt("hidden_layer_sizes", "The type and the size of the hidden layers, e.g. sigmoid and 5. A size of <= 0 leads to a layer size of (number_of_attributes + number of classes) / 2.", -1, Integer.MAX_VALUE, -1)));
        types.add(new ParameterTypeInt("training_cycles", "The number of training cycles used for the neural network training.", 1, Integer.MAX_VALUE, 200));
        types.add(new ParameterTypeDouble("learning_rate", "The learning rate determines by how much we change the weights at each step.", 0.0, 1.0, 0.3));
        types.add(new ParameterTypeDouble("momentum", "The momentum simply adds a fraction of the previous weight update to the current one (prevent local maxima and smoothes optimization directions).", 0.0, 1.0, 0.2));
        types.add(new ParameterTypeDouble("error_epsilon", "The optimization is stopped if the training error gets below this epsilon value.", 0.0, Double.POSITIVE_INFINITY, 0.05));
        return types;
    }
}

