/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.meta;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.NumericalAttributeStatistics;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.condition.AllInnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.learner.meta.TransformedRegressionModel;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformedRegression
extends OperatorChain {
    public TransformedRegression(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet inputSet = this.getInput(ExampleSet.class);
        int method = this.getParameterAsInt("transformation_method");
        double[] rank = null;
        double mean = 0.0;
        double stddev = 1.0;
        Attribute label = inputSet.getAttributes().getLabel();
        ExampleSet eSet = (ExampleSet)inputSet.clone();
        Attribute tempLabel = AttributeFactory.createAttribute("temp_transformed_regression_label", 4);
        eSet.getExampleTable().addAttribute(tempLabel);
        eSet.getAttributes().setLabel(tempLabel);
        Iterator r = eSet.iterator();
        switch (method) {
            case 0: {
                Example e;
                double offset = 1.0 - ((NumericalAttributeStatistics)label.getStatistics()).getMinimum();
                rank = new double[]{offset};
                while (r.hasNext()) {
                    e = (Example)r.next();
                    e.setValue(tempLabel, Math.log(offset + e.getValue(label)));
                }
                break;
            }
            case 1: {
                Example e;
                while (r.hasNext()) {
                    e = (Example)r.next();
                    e.setValue(tempLabel, Math.exp(e.getValue(label)));
                }
                break;
            }
            case 2: {
                double[] dummy = new double[eSet.size()];
                int i = 0;
                while (r.hasNext()) {
                    Example e = (Example)r.next();
                    dummy[i] = e.getValue(label);
                    ++i;
                }
                Arrays.sort(dummy);
                i = 0;
                int j = 0;
                while (j < dummy.length) {
                    if (dummy[i] != dummy[j]) {
                        dummy[++i] = dummy[j];
                    }
                    ++j;
                }
                rank = new double[i];
                j = 0;
                while (j < i) {
                    rank[j] = dummy[j];
                    ++j;
                }
                for (Example e : eSet) {
                    e.setValue(tempLabel, Arrays.binarySearch(rank, e.getValue(label)));
                }
                break;
            }
            case 3: {
                while (r.hasNext()) {
                    Example e = (Example)r.next();
                    e.setValue(tempLabel, e.getValue(label));
                }
                break;
            }
        }
        if (this.getParameterAsBoolean("z_scale")) {
            mean = ((NumericalAttributeStatistics)tempLabel.getStatistics()).getAverage();
            stddev = ((NumericalAttributeStatistics)tempLabel.getStatistics()).getVariance();
            if (stddev <= 0.0) {
                stddev = 1.0;
            }
            for (Example e : eSet) {
                e.setValue(tempLabel, (e.getValue(tempLabel) - mean) / stddev);
            }
        }
        IOContainer input = new IOContainer(new IOObject[]{eSet});
        input = this.getOperator(0).apply(input);
        Model model = input.remove(Model.class);
        TransformedRegressionModel resultModel = new TransformedRegressionModel(label, method, rank, model, this.getParameterAsBoolean("z_scale"), mean, stddev, this.getParameterAsBoolean("interpolate_rank"));
        AttributeWeights weights = null;
        try {
            weights = input.remove(AttributeWeights.class);
        }
        catch (MissingIOObjectException missingIOObjectException) {
            // empty catch block
        }
        if (weights == null) {
            return new IOObject[]{resultModel};
        }
        return new IOObject[]{resultModel, weights};
    }

    @Override
    public boolean shouldReturnInnerOutput() {
        return true;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new AllInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[]{Model.class});
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{Model.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory("transformation_method", "Type of transformation to use on the labels (log, exp, transform to mean 0 and variance 1, rank, or none).", TransformedRegressionModel.METHODS, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean("z_scale", "Scale transformed values to mean 0 and standard deviation 1?", false);
        type.setExpert(true);
        types.add(type);
        type = new ParameterTypeBoolean("interpolate_rank", "Interpolate prediction if predicted rank is not an integer?", true);
        type.setExpert(true);
        types.add(type);
        return types;
    }
}

