/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.meta;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.PredictionModel;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Component;
import java.util.LinkedList;

public class ThresholdModel
extends PredictionModel {
    private double[] thresholds;
    private Model innerModel;

    public ThresholdModel() {
    }

    public ThresholdModel(Attribute label) {
        this(label, null, null);
    }

    public ThresholdModel(Attribute label, Model innerModel, double[] thresholds) {
        super(label);
        this.innerModel = innerModel;
        this.thresholds = thresholds;
    }

    public void performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        this.innerModel.apply(exampleSet);
        for (Example example : exampleSet) {
            int predictionIndex = (int)example.getPredictedLabel();
            String className = this.getLabel().getMapping().mapIndex(predictionIndex);
            double confidence = example.getConfidence(className);
            if (!(confidence < this.thresholds[predictionIndex])) continue;
            example.setPredictedLabel(Double.NaN);
        }
    }

    public Component getVisualizationComponent(IOContainer container) {
        return this.innerModel.getVisualizationComponent(container);
    }

    public String toString() {
        LinkedList<String> thresholdList = new LinkedList<String>();
        double[] dArray = this.thresholds;
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            double d = dArray[n];
            thresholdList.add(Tools.formatIntegerIfPossible(d));
            ++n;
        }
        return "Thresholds: " + thresholdList + Tools.getLineSeparator() + this.innerModel.toString();
    }
}

