/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.meta;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.PredictionModel;
import edu.udo.cs.yale.tools.Tools;
import java.util.ArrayList;
import java.util.Iterator;

public class MultiModelByRegression
extends PredictionModel {
    private Model[] models;

    public MultiModelByRegression() {
    }

    public MultiModelByRegression(Attribute label) {
        super(label);
    }

    public MultiModelByRegression(Attribute label, Model[] models) {
        super(label);
        this.models = models;
    }

    public int getNumberOfModels() {
        return this.models.length;
    }

    public Model getModel(int index) {
        return this.models[index];
    }

    public void performPrediction(ExampleSet exampleSet, Attribute predictedLabelAttribute) throws OperatorException {
        ExampleSet[] eSet = new ExampleSet[this.getNumberOfModels()];
        int i = 0;
        while (i < this.getNumberOfModels()) {
            Model model = this.getModel(i);
            eSet[i] = (ExampleSet)exampleSet.clone();
            model.apply(eSet[i]);
            ++i;
        }
        ArrayList reader = new ArrayList(eSet.length);
        int r = 0;
        while (r < eSet.length) {
            reader.add(eSet[r].iterator());
            ++r;
        }
        Iterator originalReader = exampleSet.iterator();
        Attribute predictedLabel = exampleSet.getAttributes().getPredictedLabel();
        while (originalReader.hasNext()) {
            double bestLabel = Double.NaN;
            double highestFunctionValue = Double.NEGATIVE_INFINITY;
            int k = 0;
            while (k < reader.size()) {
                double functionValue = ((Example)((Iterator)reader.get(k)).next()).getPredictedLabel();
                if (functionValue > highestFunctionValue) {
                    highestFunctionValue = functionValue;
                    bestLabel = k;
                }
                ++k;
            }
            Example example = (Example)originalReader.next();
            example.setPredictedLabel(bestLabel);
            example.setConfidence(predictedLabel.getMapping().mapIndex((int)bestLabel), 1.0);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(String.valueOf(super.toString()) + Tools.getLineSeparator());
        int i = 0;
        while (i < this.models.length) {
            result.append(String.valueOf(i > 0 ? Tools.getLineSeparator() : "") + this.models[i].toString());
            ++i;
        }
        return result.toString();
    }
}

