/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.meta;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.Partition;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.meta.AbstractMetaLearner;
import edu.udo.cs.yale.operator.learner.meta.MultiClassClassificationModel;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiClassClassifier
extends AbstractMetaLearner {
    private static final String[] STRATEGIES = new String[]{"1 against all", "1 against 1", "exhaustive code (ECOC)", "random code (ECOC)"};
    private static final int ONE_AGAINST_ALL = 0;
    private static final int ONE_AGAINST_ONE = 1;
    private static final int EXHAUSTIVE_CODE = 2;
    private static final int RANDOM_CODE = 3;

    public MultiClassClassifier(OperatorDescription description) {
        super(description);
    }

    private SplittedExampleSet constructClassPartitionSet(ExampleSet inputSet) {
        Attribute classLabel = inputSet.getAttributes().getLabel();
        int numberOfClasses = classLabel.getMapping().size();
        int[] examples = new int[inputSet.size()];
        Iterator exampleIterator = inputSet.iterator();
        int i = 0;
        while (exampleIterator.hasNext()) {
            Example e = (Example)exampleIterator.next();
            examples[i] = (int)e.getValue(classLabel);
            ++i;
        }
        Partition separatedClasses = new Partition(examples, numberOfClasses);
        return new SplittedExampleSet((ExampleSet)inputSet.clone(), separatedClasses);
    }

    private Model[] applyCodePattern(SplittedExampleSet seSet, Attribute classLabel, CodePattern cP) throws OperatorException {
        int numberOfClasses = classLabel.getMapping().size();
        int numberOfFunctions = cP.data[0].length;
        Model[] models = new Model[numberOfFunctions];
        HashMap<Integer, Integer> classIndexMap = new HashMap<Integer, Integer>(numberOfClasses);
        int currentFunction = 0;
        while (currentFunction < numberOfFunctions) {
            int counter = 0;
            seSet.clearSelection();
            for (String currentClass : classLabel.getMapping().getValues()) {
                classIndexMap.put(classLabel.getMapping().mapString(currentClass), counter);
                if (cP.partitionEnabled[counter][currentFunction]) {
                    seSet.selectAdditionalSubset(classLabel.getMapping().mapString(currentClass));
                }
                ++counter;
            }
            Attribute workingLabel = AttributeFactory.createAttribute("multiclass_working_label", 8);
            seSet.getExampleTable().addAttribute(workingLabel);
            seSet.getAttributes().addRegular(workingLabel);
            int currentIndex = 0;
            for (Example e : seSet) {
                currentIndex = (Integer)classIndexMap.get((int)e.getValue(classLabel));
                if (!cP.partitionEnabled[currentIndex][currentFunction]) continue;
                e.setValue(workingLabel, workingLabel.getMapping().mapString(cP.data[currentIndex][currentFunction]));
            }
            seSet.getAttributes().remove(workingLabel);
            seSet.getAttributes().setLabel(workingLabel);
            models[currentFunction] = this.applyInnerLearner(seSet);
            this.inApplyLoop();
            seSet.getAttributes().setLabel(classLabel);
            seSet.getExampleTable().removeAttribute(workingLabel);
            ++currentFunction;
        }
        return models;
    }

    private CodePattern buildCodePattern_ONE_VS_ALL(Attribute classLabel) {
        int numberOfClasses = classLabel.getMapping().size();
        CodePattern cP = new CodePattern(numberOfClasses, numberOfClasses, 0);
        Iterator<String> classIt = classLabel.getMapping().getValues().iterator();
        int i = 0;
        while (i < numberOfClasses) {
            int j = 0;
            while (j < numberOfClasses) {
                cP.data[i][j] = i == j ? classIt.next() : "AllOtherClasses";
                ++j;
            }
            ++i;
        }
        return cP;
    }

    private CodePattern buildCodePattern_ONE_VS_ONE(Attribute classLabel) {
        int numberOfClasses = classLabel.getMapping().size();
        int numberOfCombinations = numberOfClasses * (numberOfClasses - 1) / 2;
        String[] classIndexMap = new String[numberOfClasses];
        CodePattern cP = new CodePattern(numberOfClasses, numberOfCombinations, 1);
        int i = 0;
        while (i < numberOfClasses) {
            int j = 0;
            while (j < numberOfCombinations) {
                cP.partitionEnabled[i][j] = false;
                ++j;
            }
            ++i;
        }
        int classIndex = 0;
        Iterator<String> iterator = classLabel.getMapping().getValues().iterator();
        while (iterator.hasNext()) {
            String className;
            classIndexMap[classIndex] = className = iterator.next();
            ++classIndex;
        }
        int currentClassA = 0;
        int currentClassB = 1;
        int counter = 0;
        while (counter < numberOfCombinations) {
            if (currentClassB > numberOfClasses - 1) {
                currentClassB = ++currentClassA + 1;
            }
            if (currentClassA > numberOfClasses - 2) break;
            cP.partitionEnabled[currentClassA][counter] = true;
            cP.partitionEnabled[currentClassB][counter] = true;
            cP.data[currentClassA][counter] = classIndexMap[currentClassA];
            cP.data[currentClassB][counter] = classIndexMap[currentClassB];
            ++currentClassB;
            ++counter;
        }
        return cP;
    }

    private CodePattern buildCodePattern_EXHAUSTIVE_CODE(Attribute classLabel) {
        int numberOfClasses = classLabel.getMapping().size();
        int numberOfFunctions = (int)Math.pow(2.0, numberOfClasses - 1) - 1;
        CodePattern cP = new CodePattern(numberOfClasses, numberOfFunctions, 2);
        int i = 0;
        while (i < numberOfFunctions) {
            cP.data[0][i] = "true";
            ++i;
        }
        i = 1;
        while (i < numberOfClasses) {
            int currentStep = (int)Math.pow(2.0, numberOfClasses - (i + 1));
            int j = 0;
            while (j < numberOfFunctions) {
                cP.data[i][j] = "" + (j / currentStep % 2 > 0);
                ++j;
            }
            ++i;
        }
        return cP;
    }

    private CodePattern buildCodePattern_RANDOM_CODE(Attribute classLabel) throws OperatorException {
        double multiplicator = this.getParameterAsDouble("random_code_multiplicator");
        int randomSeed = this.getParameterAsInt("local_random_seed");
        int numberOfClasses = classLabel.getMapping().size();
        CodePattern cP = new CodePattern(numberOfClasses, (int)((double)numberOfClasses * multiplicator), 3);
        RandomGenerator randomGenerator = RandomGenerator.getRandomGenerator(randomSeed);
        int i = 0;
        while (i < cP.data.length) {
            int j = 0;
            while (j < cP.data[0].length) {
                cP.data[i][j] = "" + randomGenerator.nextBoolean();
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < cP.data[0].length) {
            boolean containsNoOne = true;
            boolean containsNoZero = true;
            int j = 0;
            while (j < cP.data.length) {
                if ("true".equals(cP.data[j][i])) {
                    containsNoOne = false;
                } else {
                    containsNoZero = false;
                }
                ++j;
            }
            if (containsNoOne) {
                cP.data[(int)randomGenerator.nextDouble() * (cP.data.length - 1)][i] = "true";
            }
            if (containsNoZero) {
                cP.data[(int)randomGenerator.nextDouble() * (cP.data.length - 1)][i] = "false";
            }
            ++i;
        }
        return cP;
    }

    @Override
    public Model learn(ExampleSet inputSet) throws OperatorException {
        int classificationStrategy = this.getParameterAsInt("classification_strategies");
        Attribute classLabel = inputSet.getAttributes().getLabel();
        SplittedExampleSet seSet = this.constructClassPartitionSet(inputSet);
        switch (classificationStrategy) {
            case 0: {
                LogService.logMessage("Binary2MultiCLassLearner set to <<1-vs-all>>", 2);
                CodePattern cP = this.buildCodePattern_ONE_VS_ALL(classLabel);
                Model[] models = this.applyCodePattern(seSet, classLabel, cP);
                return new MultiClassClassificationModel(classLabel, models, classificationStrategy);
            }
            case 1: {
                LogService.logMessage("Binary2MultiCLassLearner set to <<1-vs-1>>", 2);
                CodePattern cP = this.buildCodePattern_ONE_VS_ONE(classLabel);
                Model[] models = this.applyCodePattern(seSet, classLabel, cP);
                return new MultiClassClassificationModel(classLabel, models, classificationStrategy);
            }
            case 2: {
                LogService.logMessage("Binary2MultiCLassLearner set to <<exhaustive code>>", 2);
                CodePattern cP = this.buildCodePattern_EXHAUSTIVE_CODE(classLabel);
                Model[] models = this.applyCodePattern(seSet, classLabel, cP);
                return new MultiClassClassificationModel(classLabel, models, classificationStrategy, cP.data);
            }
            case 3: {
                LogService.logMessage("Binary2MultiCLassLearner set to <<random code>>", 2);
                CodePattern cP = this.buildCodePattern_RANDOM_CODE(classLabel);
                Model[] models = this.applyCodePattern(seSet, classLabel, cP);
                return new MultiClassClassificationModel(classLabel, models, classificationStrategy, cP.data);
            }
        }
        throw new OperatorException("Unknown classification strategy selected");
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory("classification_strategies", "What strategy should be used for multi class classifications?", STRATEGIES, 0));
        types.add(new ParameterTypeDouble("random_code_multiplicator", "A multiplicator regulating the codeword length in random code modus.", 1.0, Double.POSITIVE_INFINITY, 2.0));
        types.add(new ParameterTypeInt("local_random_seed", "Use the given random seed instead of global random numbers (-1: use global)", -1, Integer.MAX_VALUE, -1));
        return types;
    }

    private class CodePattern {
        String[][] data;
        boolean[][] partitionEnabled;
        int classificationStrategy;

        public CodePattern(int numberOfClasses, int numberOfFunctions, int classificationStrategy) {
            this.data = new String[numberOfClasses][numberOfFunctions];
            this.partitionEnabled = new boolean[numberOfClasses][numberOfFunctions];
            int i = 0;
            while (i < numberOfClasses) {
                int j = 0;
                while (j < numberOfFunctions) {
                    this.partitionEnabled[i][j] = true;
                    ++j;
                }
                ++i;
            }
            this.classificationStrategy = classificationStrategy;
        }
    }
}

