/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.meta;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.PredictionModel;
import edu.udo.cs.yale.tools.Tools;
import java.util.HashMap;
import java.util.Iterator;

public class MultiClassClassificationModel
extends PredictionModel {
    private static final int ONE_AGAINST_ALL = 0;
    private static final int ONE_AGAINST_ONE = 1;
    private static final int EXHAUSTIVE_CODE = 2;
    private static final int RANDOM_CODE = 3;
    private Model[] models;
    private String[][] codeMatrix;
    private int classificationType;

    public MultiClassClassificationModel() {
    }

    public MultiClassClassificationModel(Attribute label) {
        super(label);
    }

    public MultiClassClassificationModel(Attribute label, Model[] models, int classificationType) {
        super(label);
        this.models = models;
        this.classificationType = classificationType;
    }

    public MultiClassClassificationModel(Attribute label, Model[] models, int classificationType, String[][] codeMatrix) {
        super(label);
        this.models = models;
        this.classificationType = classificationType;
        this.codeMatrix = codeMatrix;
    }

    public int getNumberOfModels() {
        return this.models.length;
    }

    public Model getModel(int index) {
        return this.models[index];
    }

    private void startNonECOCProcess(ExampleSet originalExampleSet, int classificationStrategy) throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)originalExampleSet.clone();
        int numberOfClasses = this.getLabel().getMapping().getValues().size();
        int currentNumber = 0;
        HashMap<Integer, Integer> classIndexMap = new HashMap<Integer, Integer>(numberOfClasses);
        for (String currentClass : this.getLabel().getMapping().getValues()) {
            classIndexMap.put(currentNumber, this.getLabel().getMapping().mapString(currentClass));
            ++currentNumber;
        }
        double[][] confidenceMatrix = new double[exampleSet.size()][this.getNumberOfModels()];
        int k = 0;
        while (k < confidenceMatrix[0].length) {
            Model model = this.getModel(k);
            model.apply(exampleSet);
            Iterator reader = exampleSet.iterator();
            int counter = 0;
            while (reader.hasNext()) {
                Example example = (Example)reader.next();
                if (classificationStrategy == 1) {
                    for (String className : exampleSet.getAttributes().getPredictedLabel().getMapping().getValues()) {
                        double[] dArray = confidenceMatrix[counter];
                        int n = this.getLabel().getMapping().mapString(className);
                        dArray[n] = dArray[n] + example.getConfidence(className);
                    }
                } else {
                    confidenceMatrix[counter][k] = example.getConfidence(this.getLabel().getMapping().mapIndex((Integer)classIndexMap.get(k)));
                }
                ++counter;
            }
            PredictionModel.removePredictedLabel(exampleSet);
            ++k;
        }
        Iterator reader = originalExampleSet.iterator();
        int counter = 0;
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            double confidenceSum = 0.0;
            double currentConfidence = 0.0;
            double bestConfidence = Double.NEGATIVE_INFINITY;
            int bestIndex = -1;
            int i = 0;
            while (i < confidenceMatrix[counter].length) {
                currentConfidence = confidenceMatrix[counter][i];
                if (currentConfidence > bestConfidence) {
                    bestConfidence = currentConfidence;
                    bestIndex = i;
                }
                confidenceSum += currentConfidence;
                ++i;
            }
            example.setPredictedLabel(((Integer)classIndexMap.get(bestIndex)).intValue());
            i = 0;
            while (i < numberOfClasses) {
                example.setConfidence(this.getLabel().getMapping().mapIndex((Integer)classIndexMap.get(i)), confidenceMatrix[counter][i] / confidenceSum);
                ++i;
            }
            ++counter;
        }
    }

    private void startECOCProcess(ExampleSet originalExampleSet, String[][] codeMatrix) throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)originalExampleSet.clone();
        int numberOfClasses = codeMatrix.length;
        int currentNumber = 0;
        HashMap<Integer, String> classIndexMap = new HashMap<Integer, String>(numberOfClasses);
        for (String currentClass : this.getLabel().getMapping().getValues()) {
            classIndexMap.put(currentNumber, currentClass);
            ++currentNumber;
        }
        double[][] codeWords = new double[codeMatrix.length][codeMatrix[0].length];
        int i = 0;
        while (i < codeMatrix.length) {
            int j = 0;
            while (j < codeMatrix[0].length) {
                codeWords[i][j] = "true".equals(codeMatrix[i][j]) ? 1.0 : 0.0;
                ++j;
            }
            ++i;
        }
        double[][] confidenceMatrix = new double[exampleSet.size()][this.getNumberOfModels()];
        int k = 0;
        while (k < confidenceMatrix[0].length) {
            Model model = this.getModel(k);
            model.apply(exampleSet);
            Iterator reader = exampleSet.iterator();
            int counter = 0;
            while (reader.hasNext()) {
                Example example = (Example)reader.next();
                Attribute predictedLabel = example.getAttributes().getPredictedLabel();
                String currentLabel = predictedLabel.getMapping().mapIndex((int)example.getValue(predictedLabel));
                double currentConfidence = example.getConfidence(currentLabel);
                confidenceMatrix[counter][k] = "true".equals(currentLabel) ? currentConfidence : 1.0 - currentConfidence;
                ++counter;
            }
            PredictionModel.removePredictedLabel(exampleSet);
            ++k;
        }
        Iterator reader = originalExampleSet.iterator();
        int counter = 0;
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            int bestIndex = -1;
            double[] confidenceVector = new double[numberOfClasses];
            double bestConfidence = Double.POSITIVE_INFINITY;
            int i2 = 0;
            while (i2 < numberOfClasses) {
                confidenceVector[i2] = 0.0;
                int j = 0;
                while (j < confidenceMatrix[counter].length) {
                    confidenceVector[i2] = confidenceVector[i2] + Math.abs(confidenceMatrix[counter][j] - codeWords[i2][j]);
                    ++j;
                }
                if (confidenceVector[i2] < bestConfidence) {
                    bestConfidence = confidenceVector[i2];
                    bestIndex = i2;
                }
                ++i2;
            }
            example.setPredictedLabel(this.getLabel().getMapping().mapString((String)classIndexMap.get(bestIndex)));
            int numberOfFunctions = codeMatrix[0].length;
            int i3 = 0;
            while (i3 < numberOfClasses) {
                example.setConfidence((String)classIndexMap.get(i3), ((double)numberOfFunctions - confidenceVector[i3]) / (double)numberOfFunctions);
                ++i3;
            }
            ++counter;
        }
    }

    public void performPrediction(ExampleSet originalExampleSet, Attribute predictedLabel) throws OperatorException {
        switch (this.classificationType) {
            case 0: {
                this.startNonECOCProcess(originalExampleSet, 0);
                break;
            }
            case 1: {
                this.startNonECOCProcess(originalExampleSet, 1);
                break;
            }
            case 2: {
                this.startECOCProcess(originalExampleSet, this.codeMatrix);
                break;
            }
            case 3: {
                this.startECOCProcess(originalExampleSet, this.codeMatrix);
                break;
            }
            default: {
                throw new OperatorException("Unknown classification strategy selected");
            }
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(String.valueOf(super.toString()) + Tools.getLineSeparator());
        int i = 0;
        while (i < this.models.length) {
            result.append(String.valueOf(i > 0 ? Tools.getLineSeparator() : "") + this.models[i].toString());
            ++i;
        }
        return result.toString();
    }
}

