/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.meta;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.meta.AbstractMetaLearner;
import edu.udo.cs.yale.operator.learner.meta.MultiModelByRegression;

public class ClassificationByRegression
extends AbstractMetaLearner {
    private int numberOfClasses;

    public ClassificationByRegression(OperatorDescription description) {
        super(description);
    }

    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.POLYNOMINAL_CLASS || lc == LearnerCapability.BINOMINAL_CLASS || lc == LearnerCapability.NUMERICAL_CLASS) {
            return true;
        }
        return super.supportsCapability(lc);
    }

    public Model learn(ExampleSet inputSet) throws OperatorException {
        Attribute classLabel = inputSet.getAttributes().getLabel();
        this.numberOfClasses = classLabel.getMapping().getValues().size();
        Model[] models = new Model[this.numberOfClasses];
        ExampleSet eSet = (ExampleSet)inputSet.clone();
        Attribute tempLabel = AttributeFactory.createAttribute("temp_regression_label", 4);
        eSet.getExampleTable().addAttribute(tempLabel);
        eSet.getAttributes().setLabel(tempLabel);
        int i = 0;
        while (i < this.numberOfClasses) {
            for (Example e : eSet) {
                if (e.getValue(classLabel) == (double)i) {
                    e.setValue(tempLabel, 1.0);
                    continue;
                }
                e.setValue(tempLabel, -1.0);
            }
            models[i] = this.applyInnerLearner(eSet);
            this.inApplyLoop();
            ++i;
        }
        return new MultiModelByRegression(classLabel, models);
    }
}

