/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.meta;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.PredictionModel;
import edu.udo.cs.yale.operator.learner.meta.BayBoostBaseModelInfo;
import edu.udo.cs.yale.operator.learner.meta.ContingencyMatrix;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BayBoostModel
extends PredictionModel {
    private List<BayBoostBaseModelInfo> modelInfo;
    private double[] priors;
    private int maxModelNumber = -1;
    private static final String MAX_MODEL_NUMBER = "iteration";
    private static final String CONV_TO_CRISP = "crisp";
    private double threshold = 0.5;

    public BayBoostModel() {
    }

    public BayBoostModel(Attribute label) {
        super(label);
    }

    public BayBoostModel(Attribute label, List<BayBoostBaseModelInfo> modelInfos, double[] priors) {
        super(label);
        this.modelInfo = modelInfos;
        this.priors = priors;
    }

    public BayBoostBaseModelInfo getBayBoostBaseModelInfo(int index) {
        return this.modelInfo.get(index);
    }

    public void setParameter(String name, String value) throws OperatorException {
        if (name.equalsIgnoreCase(MAX_MODEL_NUMBER)) {
            try {
                this.maxModelNumber = Integer.parseInt(value);
                return;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (name.equalsIgnoreCase(CONV_TO_CRISP)) {
            this.threshold = Double.parseDouble(value.trim());
            return;
        }
        super.setParameter(name, value);
    }

    public void setMaxModelNumber(int numModels) {
        this.maxModelNumber = numModels;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(String.valueOf(super.toString()) + Tools.getLineSeparator() + "Number of inner models: " + this.getNumberOfModels());
        int i = 0;
        while (i < this.getNumberOfModels()) {
            Model model = this.getModel(i);
            result.append(String.valueOf(i > 0 ? Tools.getLineSeparator() : "") + "(Embedded model #" + i + "):" + model.toResultString());
            ++i;
        }
        return result.toString();
    }

    public int getNumberOfModels() {
        if (this.maxModelNumber >= 0) {
            return Math.min(this.maxModelNumber, this.modelInfo.size());
        }
        return this.modelInfo.size();
    }

    private double[] getFactorsForModel(int modelNr, int predicted) {
        ContingencyMatrix cm = this.modelInfo.get(modelNr).getContingencyMatrix();
        return cm.getLiftRatiosForPrediction(predicted);
    }

    private double getPriorOfClass(int classIndex) {
        return this.priors[classIndex];
    }

    public double[] getPriors() {
        double[] result = new double[this.priors.length];
        System.arraycopy(this.priors, 0, result, 0, result.length);
        return result;
    }

    public Model getModel(int index) {
        return this.modelInfo.get(index).getModel();
    }

    public ContingencyMatrix getContingencyMatrix(int index) {
        return this.modelInfo.get(index).getContingencyMatrix();
    }

    @Override
    public void performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        Attribute[] specialAttributes = this.createSpecialAttributes(exampleSet);
        this.initIntermediateResultAttributes(exampleSet, specialAttributes);
        int i = 0;
        while (i < this.getNumberOfModels()) {
            Model model = this.getModel(i);
            ExampleSet clonedExampleSet = (ExampleSet)exampleSet.clone();
            model.apply(clonedExampleSet);
            this.updateEstimates(clonedExampleSet, this.getContingencyMatrix(i), specialAttributes);
            PredictionModel.removePredictedLabel(clonedExampleSet);
            ++i;
        }
        for (Example example : exampleSet) {
            this.translateOddsIntoPredictions(example, specialAttributes, exampleSet.getAttributes().getLabel());
        }
        this.cleanUpSpecialAttributes(exampleSet, specialAttributes);
    }

    private Attribute[] createSpecialAttributes(ExampleSet exampleSet) throws OperatorException {
        String attributePrefix = "BayBoostModelPrediction";
        Attribute[] specialAttributes = new Attribute[this.getLabel().getMapping().size()];
        int i = 0;
        while (i < specialAttributes.length) {
            specialAttributes[i] = edu.udo.cs.yale.example.Tools.createSpecialAttribute(exampleSet, "BayBoostModelPrediction" + i, 2);
            ++i;
        }
        return specialAttributes;
    }

    private void cleanUpSpecialAttributes(ExampleSet exampleSet, Attribute[] specialAttributes) throws OperatorException {
        int i = 0;
        while (i < specialAttributes.length) {
            exampleSet.getAttributes().remove(specialAttributes[i]);
            exampleSet.getExampleTable().removeAttribute(specialAttributes[i]);
            ++i;
        }
    }

    private void initIntermediateResultAttributes(ExampleSet exampleSet, Attribute[] specAttrib) {
        double[] priorOdds = new double[this.priors.length];
        int i = 0;
        while (i < priorOdds.length) {
            priorOdds[i] = this.priors[i] == 1.0 ? Double.POSITIVE_INFINITY : this.priors[i] / (1.0 - this.priors[i]);
            ++i;
        }
        for (Example example : exampleSet) {
            int i2 = 0;
            while (i2 < specAttrib.length) {
                example.setValue(specAttrib[i2], priorOdds[i2]);
                ++i2;
            }
        }
    }

    private void translateOddsIntoPredictions(Example example, Attribute[] specAttrib, Attribute exampleSetLabel) {
        String bestLabel;
        double probSum = 0.0;
        double[] classProb = new double[specAttrib.length];
        int bestIndex = 0;
        int n = 0;
        while (n < classProb.length) {
            double odds = example.getValue(specAttrib[n]);
            if (Double.isNaN(odds)) {
                LogService.logMessage("Found NaN odd ratio estimate.", 4);
                classProb[n] = 1.0;
            } else {
                classProb[n] = Double.isInfinite(odds) ? 1.0 : odds / (1.0 + odds);
            }
            probSum += classProb[n];
            if (classProb[n] > classProb[bestIndex]) {
                bestIndex = n;
            }
            ++n;
        }
        if (probSum != 1.0) {
            int k = 0;
            while (k < classProb.length) {
                int n2 = k++;
                classProb[n2] = classProb[n2] / probSum;
            }
        }
        if (this.getLabel().isNominal() && this.getLabel().getMapping().size() == 2 && this.threshold != 0.5) {
            int posIndex = this.getLabel().getMapping().getPositiveIndex();
            int negIndex = this.getLabel().getMapping().getNegativeIndex();
            this.threshold = this.threshold >= 0.0 && this.threshold <= 1.0 ? this.threshold : 0.5;
            bestLabel = this.getLabel().getMapping().mapIndex(classProb[posIndex] >= this.threshold ? posIndex : negIndex);
        } else {
            bestLabel = this.getLabel().getMapping().mapIndex(bestIndex);
        }
        example.setValue(example.getAttributes().getPredictedLabel(), exampleSetLabel.getMapping().mapString(bestLabel));
        int k = 0;
        while (k < classProb.length) {
            if (Double.isNaN(classProb[k]) || classProb[k] < 0.0 || classProb[k] > 1.0) {
                LogService.logMessage("Found illegal confidence value: " + classProb[k], 4);
            }
            example.setConfidence(this.getLabel().getMapping().mapIndex(k), classProb[k]);
            ++k;
        }
    }

    private void updateEstimates(ExampleSet exampleSet, ContingencyMatrix cm, Attribute[] specialAttributes) {
        for (Example example : exampleSet) {
            int predicted = (int)example.getPredictedLabel();
            int j = 0;
            while (j < cm.getNumberOfClasses()) {
                double liftRatioCurrent = cm.getLiftRatio(j, predicted);
                if (Double.isNaN(liftRatioCurrent)) {
                    LogService.logMessage("Ignoring non-applicable model.", 4);
                } else if (Double.isInfinite(liftRatioCurrent)) {
                    if (example.getValue(specialAttributes[j]) != 0.0) {
                        int k = 0;
                        while (k < specialAttributes.length) {
                            example.setValue(specialAttributes[k], 0.0);
                            ++k;
                        }
                        example.setValue(specialAttributes[j], liftRatioCurrent);
                    }
                } else {
                    double oldValue = example.getValue(specialAttributes[j]);
                    if (Double.isNaN(oldValue)) {
                        LogService.logMessage("Found NaN value in intermediate odds ratio estimates!", 4);
                    }
                    if (!Double.isInfinite(oldValue)) {
                        example.setValue(specialAttributes[j], oldValue * liftRatioCurrent);
                    }
                }
                ++j;
            }
        }
    }

    public static boolean adjustIntermediateProducts(double[] products, double[] liftFactors) {
        int i = 0;
        while (i < liftFactors.length) {
            if (Double.isNaN(liftFactors[i])) {
                LogService.logMessage("Ignoring non-applicable model.", 4);
            } else if (Double.isInfinite(liftFactors[i])) {
                if (products[i] != 0.0) {
                    int j = 0;
                    while (j < products.length) {
                        products[j] = 0.0;
                        ++j;
                    }
                    products[i] = liftFactors[i];
                    return true;
                }
            } else {
                int n = i;
                products[n] = products[n] * liftFactors[i];
                if (Double.isNaN(products[i])) {
                    LogService.logMessage("Found NaN value in intermediate odds ratio estimates!", 4);
                }
            }
            ++i;
        }
        return false;
    }

    public double[] getModelWeights() throws OperatorException {
        if (this.getLabel().getMapping().size() != 2) {
            throw new OperatorException("BayBoostModel.getModelWeights() is only applicable for binary prediction tasks.");
        }
        int maxWeight = 10;
        int pos = this.getLabel().getMapping().getPositiveIndex();
        int neg = this.getLabel().getMapping().getNegativeIndex();
        double[] weights = new double[this.getNumberOfModels() + 1];
        double odds = this.getPriorOfClass(pos) / this.getPriorOfClass(neg);
        weights[0] = Math.log(odds);
        int i = 1;
        while (i < weights.length) {
            double[] liftRatiosPos = this.getFactorsForModel(i - 1, pos);
            double logPosRatio = Math.log(liftRatiosPos[pos]);
            logPosRatio = Math.min((double)maxWeight, Math.max((double)(-maxWeight), logPosRatio));
            double[] liftRatiosNeg = this.getFactorsForModel(i - 1, neg);
            double logNegRatio = Math.log(liftRatiosNeg[pos]);
            double indep = (logPosRatio + (logNegRatio = Math.min((double)maxWeight, Math.max((double)(-maxWeight), logNegRatio)))) / 2.0;
            if (indep == (double)maxWeight || indep == (double)(-maxWeight)) {
                logPosRatio = 10.0 * indep;
                indep = 0.0;
            }
            weights[0] = weights[0] + indep;
            weights[i] = logPosRatio -= indep;
            ++i;
        }
        return weights;
    }
}

