/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.meta;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.PredictionModel;
import edu.udo.cs.yale.tools.Tools;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaggingModel
extends PredictionModel {
    private List<Model> models;

    public BaggingModel() {
    }

    public BaggingModel(Attribute label) {
        super(label);
    }

    public BaggingModel(Attribute label, List<Model> models) {
        super(label);
        this.models = models;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(String.valueOf(super.toString()) + Tools.getLineSeparator() + "Number of inner models: " + this.getNumberOfModels());
        int i = 0;
        while (i < this.getNumberOfModels()) {
            Model model = this.getModel(i);
            result.append(String.valueOf(i > 0 ? Tools.getLineSeparator() : "") + "(Embedded model #" + i + "):" + model.toResultString());
            ++i;
        }
        return result.toString();
    }

    public int getNumberOfModels() {
        return this.models.size();
    }

    public Model getModel(int index) {
        return this.models.get(index);
    }

    @Override
    public void performPrediction(ExampleSet origExampleSet, Attribute predictedLabel) throws OperatorException {
        String attributePrefix = "BaggingModelPrediction";
        int numLabels = predictedLabel.getMapping().size();
        Attribute[] specialAttributes = new Attribute[numLabels];
        int i = 0;
        while (i < numLabels) {
            specialAttributes[i] = edu.udo.cs.yale.example.Tools.createSpecialAttribute(origExampleSet, "BaggingModelPrediction" + i, 2);
            ++i;
        }
        for (Example example : origExampleSet) {
            int i2 = 0;
            while (i2 < specialAttributes.length) {
                example.setValue(specialAttributes[i2], 0.0);
                ++i2;
            }
        }
        Iterator reader = origExampleSet.iterator();
        int modelNr = 0;
        while (modelNr < this.getNumberOfModels()) {
            Model model = this.getModel(modelNr);
            ExampleSet exampleSet = (ExampleSet)origExampleSet.clone();
            model.apply(exampleSet);
            this.updateEstimates(exampleSet, modelNr, specialAttributes);
            PredictionModel.removePredictedLabel(exampleSet);
            ++modelNr;
        }
        this.evaluateSpecialAttributes(origExampleSet, specialAttributes);
        int i3 = 0;
        while (i3 < numLabels) {
            origExampleSet.getAttributes().remove(specialAttributes[i3]);
            origExampleSet.getExampleTable().removeAttribute(specialAttributes[i3]);
            ++i3;
        }
    }

    private void updateEstimates(ExampleSet exampleSet, int modelNr, Attribute[] specialAttributes) {
        int numModels = this.getNumberOfModels();
        int numClasses = this.getLabel().getMapping().size();
        for (Example example : exampleSet) {
            int i = 0;
            while (i < numClasses) {
                String consideredPrediction = this.getLabel().getMapping().mapIndex(i);
                double confidence = example.getConfidence(consideredPrediction);
                double value = example.getValue(specialAttributes[i]);
                example.setValue(specialAttributes[i], value += confidence / (double)numModels);
                ++i;
            }
        }
    }

    private void evaluateSpecialAttributes(ExampleSet exampleSet, Attribute[] specialAttributes) {
        Attribute exSetLabel = exampleSet.getAttributes().getLabel();
        for (Example example : exampleSet) {
            int bestLabel = 0;
            double bestConf = -1.0;
            int n = 0;
            while (n < specialAttributes.length) {
                double curConf = example.getValue(specialAttributes[n]);
                String curPredS = this.getLabel().getMapping().mapIndex(n);
                example.setConfidence(curPredS, curConf);
                if (curConf > bestConf) {
                    bestConf = curConf;
                    bestLabel = n;
                }
                ++n;
            }
            example.setValue(example.getAttributes().getPredictedLabel(), exSetLabel.getMapping().mapString(this.getLabel().getMapping().mapIndex(bestLabel)));
        }
    }

    @Override
    protected Attribute createPredictedLabel(ExampleSet exampleSet) {
        return super.createPredictedLabel(exampleSet);
    }
}

