/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.meta;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.meta.AbstractMetaLearner;
import edu.udo.cs.yale.operator.learner.meta.AdaBoostModel;
import edu.udo.cs.yale.operator.learner.meta.BaggingModel;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bagging
extends AbstractMetaLearner {
    public static final String NUM_OF_ITERATIONS = "iterations";
    public static final String INTERNAL_BOOTSTRAP = "use_subset_for_training";
    public static final String USE_CONFIDENCES = "average_confidences";
    protected int currentIteration;

    public Bagging(OperatorDescription description) {
        super(description);
        this.addValue(new Value("iteration", "The current iteration."){

            public double getValue() {
                return Bagging.this.currentIteration;
            }
        });
    }

    @Override
    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.NUMERICAL_CLASS) {
            return false;
        }
        return super.supportsCapability(lc);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeDouble(INTERNAL_BOOTSTRAP, "Fraction of examples used for training. Must be greater than 0 and should be lower than 1.", 0.0, 1.0, 0.9));
        types.add(new ParameterTypeInt(NUM_OF_ITERATIONS, "The number of iterations (base models).", 1, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeBoolean(USE_CONFIDENCES, "Specifies whether to average available prediction confidences or not.", true));
        return types;
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        double splitRatio = this.getParameterAsDouble(INTERNAL_BOOTSTRAP);
        int numInterations = this.getParameterAsInt(NUM_OF_ITERATIONS);
        Vector<Model> modelList = new Vector<Model>();
        this.currentIteration = 0;
        while (this.currentIteration < numInterations) {
            SplittedExampleSet splitted = new SplittedExampleSet(exampleSet, splitRatio, 1, -1);
            splitted.selectSingleSubset(0);
            modelList.add(this.applyInnerLearner(splitted));
            this.inApplyLoop();
            ++this.currentIteration;
        }
        if (this.getParameterAsBoolean(USE_CONFIDENCES)) {
            return new BaggingModel(exampleSet.getAttributes().getLabel(), modelList);
        }
        Vector<Double> weights = new Vector<Double>();
        int i = 0;
        while (i < modelList.size()) {
            weights.add(1.0);
            ++i;
        }
        return new AdaBoostModel(exampleSet.getAttributes().getLabel(), modelList, weights);
    }
}

