/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.meta;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.PredictionModel;
import edu.udo.cs.yale.tools.Tools;
import java.util.Iterator;

public class AdditiveRegressionModel
extends PredictionModel {
    private Model defaultModel;
    private Model[] residualModels;
    private double shrinkage;

    public AdditiveRegressionModel() {
    }

    public AdditiveRegressionModel(Attribute label) {
        super(label);
    }

    public AdditiveRegressionModel(Attribute label, Model defaultModel, Model[] residualModels, double shrinkage) {
        super(label);
        this.defaultModel = defaultModel;
        this.residualModels = residualModels;
        this.shrinkage = shrinkage;
    }

    public void performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        this.defaultModel.apply(exampleSet);
        double[] predictions = new double[exampleSet.size()];
        Iterator e = exampleSet.iterator();
        int counter = 0;
        while (e.hasNext()) {
            predictions[counter++] = ((Example)e.next()).getPredictedLabel();
        }
        int i = 0;
        while (i < this.residualModels.length) {
            this.residualModels[i].apply(exampleSet);
            e = exampleSet.iterator();
            counter = 0;
            while (e.hasNext()) {
                int n = counter++;
                predictions[n] = predictions[n] + this.shrinkage * ((Example)e.next()).getPredictedLabel();
            }
            ++i;
        }
        e = exampleSet.iterator();
        counter = 0;
        while (e.hasNext()) {
            ((Example)e.next()).setValue(predictedLabel, predictions[counter++]);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append("Default model:" + Tools.getLineSeparator() + this.defaultModel.toString() + Tools.getLineSeparator() + Tools.getLineSeparator());
        result.append("Number of base models: " + this.residualModels.length + Tools.getLineSeparator());
        result.append("Shrinkage: " + this.shrinkage + Tools.getLineSeparator());
        int i = 0;
        while (i < this.residualModels.length) {
            result.append(String.valueOf(Tools.getLineSeparator()) + Tools.ordinalNumber(i + 1) + " Model:" + Tools.getLineSeparator() + this.residualModels[i] + Tools.getLineSeparator());
            ++i;
        }
        return result.toString();
    }
}

