/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.meta;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.meta.WeightedPerformanceMeasures;
import java.util.Iterator;

public class AdaBoostPerformanceMeasures
extends WeightedPerformanceMeasures {
    private final double errorRate;

    public AdaBoostPerformanceMeasures(ExampleSet exampleSet) throws OperatorException {
        super(exampleSet);
        int num = this.getNumberOfLabels();
        double correct = 0.0;
        int i = 0;
        while (i < num) {
            correct += this.getProbability(i, i);
            ++i;
        }
        this.errorRate = Math.max(0.0, Math.min(1.0, 1.0 - correct));
    }

    public double getErrorRate() {
        return this.errorRate;
    }

    public double reweightExamples(ExampleSet exampleSet) throws OperatorException {
        double reweightWrongPred;
        double reweightRightPred;
        double err = this.getErrorRate();
        if (err == 0.0 || err == 1.0) {
            reweightRightPred = 1.0;
            reweightWrongPred = 1.0;
        } else {
            reweightRightPred = Math.sqrt(err / (1.0 - err));
            reweightWrongPred = 1.0 / reweightRightPred;
        }
        double totalWeight = 0.0;
        Iterator reader = exampleSet.iterator();
        Attribute weightAttribute = exampleSet.getAttributes().getWeight();
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            int label = (int)example.getLabel();
            int predicted = (int)example.getPredictedLabel();
            double newWeight = example.getValue(weightAttribute) * (label == predicted ? reweightRightPred : reweightWrongPred);
            example.setValue(weightAttribute, newWeight);
            totalWeight += newWeight;
        }
        return totalWeight;
    }
}

