/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.meta;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.PredictionModel;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaBoostModel
extends PredictionModel {
    public static final String ID = "YALE AdaBoost Model";
    private List<Model> models;
    private List<Double> weights;
    private int maxModelNumber = -1;
    private static final String MAX_MODEL_NUMBER = "iteration";

    public AdaBoostModel() {
    }

    public AdaBoostModel(Attribute label) {
        super(label);
    }

    public AdaBoostModel(Attribute label, List<Model> models, List<Double> weights) {
        super(label);
        this.models = models;
        this.weights = weights;
        for (double i : weights) {
            if (!Double.isNaN(i) && !Double.isInfinite(i)) continue;
            LogService.logMessage("Found model weight " + i, 4);
        }
    }

    public void setParameter(String name, String value) throws OperatorException {
        if (name.equalsIgnoreCase(MAX_MODEL_NUMBER)) {
            try {
                this.maxModelNumber = Integer.parseInt(value);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        super.setParameter(name, value);
    }

    public void setMaxModelNumber(int numModels) {
        this.maxModelNumber = numModels;
    }

    public String getIdentifier() {
        return ID;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(String.valueOf(super.toString()) + Tools.getLineSeparator() + "Number of inner models: " + this.getNumberOfModels());
        int i = 0;
        while (i < this.getNumberOfModels()) {
            Model model = this.getModel(i);
            result.append(String.valueOf(i > 0 ? Tools.getLineSeparator() : "") + "Weight: " + this.getWeightForModel(i) + "," + "(Embedded model #" + i + "):" + model.toResultString());
            ++i;
        }
        return result.toString();
    }

    public int getNumberOfModels() {
        if (this.maxModelNumber >= 0) {
            return Math.min(this.maxModelNumber, this.models.size());
        }
        return this.models.size();
    }

    private double getWeightForModel(int modelNr) {
        return this.weights.get(modelNr);
    }

    public Model getModel(int index) {
        return this.models.get(index);
    }

    @Override
    public void performPrediction(ExampleSet origExampleSet, Attribute predictedLabel) throws OperatorException {
        String attributePrefix = "AdaBoostModelPrediction";
        int numLabels = predictedLabel.getMapping().size();
        Attribute[] specialAttributes = new Attribute[numLabels];
        int i = 0;
        while (i < numLabels) {
            specialAttributes[i] = edu.udo.cs.yale.example.Tools.createSpecialAttribute(origExampleSet, "AdaBoostModelPrediction" + i, 2);
            ++i;
        }
        for (Example example : origExampleSet) {
            int i2 = 0;
            while (i2 < specialAttributes.length) {
                example.setValue(specialAttributes[i2], 0.0);
                ++i2;
            }
        }
        Iterator reader = origExampleSet.iterator();
        int modelNr = 0;
        while (modelNr < this.getNumberOfModels()) {
            Model model = this.getModel(modelNr);
            ExampleSet exampleSet = (ExampleSet)origExampleSet.clone();
            model.apply(exampleSet);
            this.updateEstimates(exampleSet, modelNr, specialAttributes);
            PredictionModel.removePredictedLabel(exampleSet);
            ++modelNr;
        }
        this.evaluateSpecialAttributes(origExampleSet, specialAttributes);
        int i3 = 0;
        while (i3 < numLabels) {
            origExampleSet.getAttributes().remove(specialAttributes[i3]);
            origExampleSet.getExampleTable().removeAttribute(specialAttributes[i3]);
            ++i3;
        }
    }

    private void updateEstimates(ExampleSet exampleSet, int modelNr, Attribute[] specialAttributes) {
        for (Example example : exampleSet) {
            int predicted;
            double oldValue = example.getValue(specialAttributes[predicted = (int)example.getPredictedLabel()]);
            if (Double.isNaN(oldValue)) {
                LogService.logMessage("Found NaN confidence as intermediate prediction.", 4);
                oldValue = 0.0;
            }
            if (Double.isInfinite(oldValue)) continue;
            example.setValue(specialAttributes[predicted], oldValue + this.getWeightForModel(modelNr));
        }
    }

    private void evaluateSpecialAttributes(ExampleSet exampleSet, Attribute[] specialAttributes) {
        Attribute exSetLabel = exampleSet.getAttributes().getLabel();
        for (Example example : exampleSet) {
            double sum = 0.0;
            double[] confidences = new double[specialAttributes.length];
            double bestConf = -1.0;
            int bestLabel = 0;
            int n = 0;
            while (n < confidences.length) {
                confidences[n] = example.getValue(specialAttributes[n]);
                if (confidences[n] > bestConf) {
                    bestConf = confidences[n];
                    bestLabel = n;
                }
                ++n;
            }
            example.setValue(example.getAttributes().getPredictedLabel(), exSetLabel.getMapping().mapString(this.getLabel().getMapping().mapIndex(bestLabel)));
            n = 0;
            while (n < confidences.length) {
                confidences[n] = Math.exp(confidences[n] - bestConf);
                sum += confidences[n];
                ++n;
            }
            if (Double.isInfinite(sum) || Double.isNaN(sum)) {
                int best = (int)example.getPredictedLabel();
                int k = 0;
                while (k < confidences.length) {
                    confidences[k] = 0.0;
                    ++k;
                }
                confidences[best] = 1.0;
                continue;
            }
            int k = 0;
            while (k < confidences.length) {
                int n2 = k;
                confidences[n2] = confidences[n2] / sum;
                example.setConfidence(exampleSet.getAttributes().getLabel().getMapping().mapIndex(k), confidences[k]);
                ++k;
            }
        }
    }

    @Override
    protected Attribute createPredictedLabel(ExampleSet exampleSet) {
        return super.createPredictedLabel(exampleSet);
    }
}

