/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.meta;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.Tools;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.PredictionModel;
import edu.udo.cs.yale.operator.learner.meta.AbstractMetaLearner;
import edu.udo.cs.yale.operator.learner.meta.AdaBoostModel;
import edu.udo.cs.yale.operator.learner.meta.AdaBoostPerformanceMeasures;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.tools.LogService;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaBoost
extends AbstractMetaLearner {
    public static final String NUM_OF_ITERATIONS = "iterations";
    public static final double MIN_ADVANTAGE = 0.001;
    protected int currentIteration;
    private double performance = 0.0;
    private double[] oldWeights;

    public AdaBoost(OperatorDescription description) {
        super(description);
        this.addValue(new Value("performance", "The performance."){

            public double getValue() {
                return AdaBoost.this.performance;
            }
        });
        this.addValue(new Value("iteration", "The current iteration."){

            public double getValue() {
                return AdaBoost.this.currentIteration;
            }
        });
    }

    @Override
    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.NUMERICAL_CLASS) {
            return false;
        }
        return super.supportsCapability(lc);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        if (!exampleSet.getAttributes().getLabel().isNominal()) {
            throw new UserError((Operator)this, 119, exampleSet.getAttributes().getLabel().getName(), (Object)this.getName());
        }
        this.performance = this.prepareWeights(exampleSet);
        AdaBoostModel model = this.trainBoostingModel(exampleSet);
        Attribute weightAttribute = exampleSet.getAttributes().getWeight();
        if (this.oldWeights != null) {
            Iterator reader = exampleSet.iterator();
            int i = 0;
            while (reader.hasNext() && i < this.oldWeights.length) {
                ((Example)reader.next()).setValue(weightAttribute, this.oldWeights[i++]);
            }
        } else {
            exampleSet.getAttributes().remove(weightAttribute);
            exampleSet.getExampleTable().removeAttribute(weightAttribute);
        }
        return model;
    }

    protected double prepareWeights(ExampleSet exampleSet) {
        Attribute weightAttr = exampleSet.getAttributes().getWeight();
        double totalWeight = 0.0;
        if (weightAttr == null) {
            this.oldWeights = null;
            weightAttr = Tools.createWeightAttribute(exampleSet);
            Iterator exRead = exampleSet.iterator();
            while (exRead.hasNext()) {
                ((Example)exRead.next()).setValue(weightAttr, 1.0);
                totalWeight += 1.0;
            }
        } else {
            this.oldWeights = new double[exampleSet.size()];
            Iterator reader = exampleSet.iterator();
            int i = 0;
            while (reader.hasNext() && i < this.oldWeights.length) {
                this.oldWeights[i] = ((Example)reader.next()).getWeight();
                totalWeight += this.oldWeights[i];
                ++i;
            }
        }
        return totalWeight;
    }

    private AdaBoostModel trainBoostingModel(ExampleSet trainingSet) throws OperatorException {
        LogService.logMessage("Total weight of example set at the beginning: " + this.performance, 2);
        Vector<Model> ensembleModels = new Vector<Model>();
        Vector<Double> ensembleWeights = new Vector<Double>();
        int iterations = this.getParameterAsInt(NUM_OF_ITERATIONS);
        int i = 0;
        while (i < iterations && this.performance > 0.0) {
            this.currentIteration = i;
            Model model = this.applyInnerLearner(trainingSet);
            model.apply(trainingSet);
            AdaBoostPerformanceMeasures wp = new AdaBoostPerformanceMeasures(trainingSet);
            this.performance = wp.reweightExamples(trainingSet);
            PredictionModel.removePredictedLabel(trainingSet);
            LogService.logMessage("Total weight of example set after iteration " + (this.currentIteration + 1) + " is " + this.performance, 2);
            if (!this.isModelUseful(wp)) {
                LogService.logMessage("Discard model because of low advantage on training data.", 2);
                return new AdaBoostModel(trainingSet.getAttributes().getLabel(), ensembleModels, ensembleWeights);
            }
            ensembleModels.add(model);
            double errorRate = wp.getErrorRate();
            double weight = errorRate == 0.0 ? Double.POSITIVE_INFINITY : Math.log((1.0 - errorRate) / errorRate);
            ensembleWeights.add(weight);
            ++i;
        }
        return new AdaBoostModel(trainingSet.getAttributes().getLabel(), ensembleModels, ensembleWeights);
    }

    private boolean isModelUseful(AdaBoostPerformanceMeasures wp) {
        return wp.getErrorRate() < 0.5;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(NUM_OF_ITERATIONS, "The maximum number of iterations.", 1, Integer.MAX_VALUE, 10));
        return types;
    }
}

