/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.meta;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.Tools;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.InputDescription;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Saveable;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.condition.CombinedInnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.LastInnerOperatorCondition;
import edu.udo.cs.yale.operator.learner.Learner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import java.util.LinkedList;

public abstract class AbstractMetaLearner
extends OperatorChain
implements Learner {
    public AbstractMetaLearner(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        PerformanceVector perfVector;
        AttributeWeights weights;
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        if (exampleSet.getAttributes().getLabel() == null) {
            throw new UserError((Operator)this, 105, new Object[0]);
        }
        if (exampleSet.getAttributes().size() == 0) {
            throw new UserError((Operator)this, 106, new Object[0]);
        }
        try {
            this.checkLearnerCapabilities(exampleSet);
        }
        catch (OperatorException e) {
            LogService.logMessage(e.getMessage(), 4);
        }
        LinkedList<Saveable> results = new LinkedList<Saveable>();
        Model model = this.learn(exampleSet);
        results.add(model);
        if (this.shouldCalculateWeights() && (weights = this.getWeights(exampleSet)) != null) {
            results.add(weights);
        }
        if (this.shouldEstimatePerformance() && (perfVector = this.getEstimatedPerformance()) != null) {
            results.add(perfVector);
        }
        IOObject[] resultArray = new IOObject[results.size()];
        results.toArray(resultArray);
        return resultArray;
    }

    public void checkLearnerCapabilities(ExampleSet exampleSet) throws OperatorException {
        Attribute label;
        if (Tools.containsValueType(exampleSet, 1)) {
            if (Tools.containsValueType(exampleSet, 8)) {
                if (!this.supportsCapability(LearnerCapability.BINOMINAL_ATTRIBUTES)) {
                    throw new UserError((Operator)this, 501, LearnerCapability.BINOMINAL_ATTRIBUTES.getDescription());
                }
            } else if (!this.supportsCapability(LearnerCapability.POLYNOMINAL_ATTRIBUTES)) {
                throw new UserError((Operator)this, 501, LearnerCapability.POLYNOMINAL_ATTRIBUTES.getDescription());
            }
        } else if (Tools.containsValueType(exampleSet, 2) && !this.supportsCapability(LearnerCapability.NUMERICAL_ATTRIBUTES)) {
            throw new UserError((Operator)this, 501, LearnerCapability.NUMERICAL_ATTRIBUTES.getDescription());
        }
        if ((label = exampleSet.getAttributes().getLabel()).isNominal()) {
            if (label.getMapping().size() == 2) {
                if (!this.supportsCapability(LearnerCapability.BINOMINAL_CLASS)) {
                    throw new UserError((Operator)this, 501, LearnerCapability.BINOMINAL_CLASS.getDescription());
                }
            } else if (!this.supportsCapability(LearnerCapability.POLYNOMINAL_CLASS)) {
                throw new UserError((Operator)this, 501, LearnerCapability.POLYNOMINAL_CLASS.getDescription());
            }
        } else if (!this.supportsCapability(LearnerCapability.NUMERICAL_CLASS)) {
            throw new UserError((Operator)this, 501, LearnerCapability.NUMERICAL_CLASS.getDescription());
        }
    }

    protected Model applyInnerLearner(ExampleSet exampleSet) throws OperatorException {
        IOContainer input = new IOContainer(new IOObject[]{exampleSet});
        int i = 0;
        while (i < this.getNumberOfOperators()) {
            input = this.getOperator(i).apply(input);
            ++i;
        }
        return input.remove(Model.class);
    }

    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    public boolean shouldReturnInnerOutput() {
        return true;
    }

    public InnerOperatorCondition getInnerOperatorCondition() {
        CombinedInnerOperatorCondition condition = new CombinedInnerOperatorCondition();
        condition.addCondition(new LastInnerOperatorCondition(new Class[]{Model.class}));
        if (this.shouldEstimatePerformance()) {
            condition.addCondition(new LastInnerOperatorCondition(new Class[]{PerformanceVector.class}));
        }
        if (this.shouldCalculateWeights()) {
            condition.addCondition(new LastInnerOperatorCondition(new Class[]{AttributeWeights.class}));
        }
        return condition;
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    public boolean shouldEstimatePerformance() {
        return false;
    }

    public boolean shouldCalculateWeights() {
        return false;
    }

    public PerformanceVector getEstimatedPerformance() throws OperatorException {
        throw new UserError((Operator)this, 912, this.getName(), (Object)"estimation of performance not supported.");
    }

    public AttributeWeights getWeights(ExampleSet exampleSet) throws OperatorException {
        throw new UserError((Operator)this, 916, this.getName(), (Object)"calculation of weights not supported.");
    }

    public boolean supportsCapability(LearnerCapability capability) {
        if (this.getNumberOfOperators() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.getNumberOfOperators()) {
            if (this.getOperator(i) instanceof Learner) {
                return ((Learner)((Object)this.getOperator(i))).supportsCapability(capability);
            }
            ++i;
        }
        return false;
    }

    public Class[] getOutputClasses() {
        LinkedList<Class<AttributeWeights>> classList = new LinkedList<Class<AttributeWeights>>();
        classList.add(Model.class);
        if (this.shouldEstimatePerformance()) {
            classList.add(PerformanceVector.class);
        }
        if (this.shouldCalculateWeights()) {
            classList.add(AttributeWeights.class);
        }
        Class[] result = new Class[classList.size()];
        classList.toArray(result);
        return result;
    }
}

