/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.lazy;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.PredictionModel;
import edu.udo.cs.yale.tools.Tools;

public class DefaultModel
extends PredictionModel {
    private double value;
    private double[] confidences;

    public DefaultModel() {
    }

    public DefaultModel(Attribute label, double value) {
        this(label, value, null);
    }

    public DefaultModel(Attribute label, double value, double[] confidences) {
        super(label);
        this.value = value;
        this.confidences = confidences;
    }

    public void performPrediction(ExampleSet exampleSet, Attribute predictedLabelAttribute) throws OperatorException {
        Attribute label = this.getLabel();
        for (Example example : exampleSet) {
            example.setValue(predictedLabelAttribute, this.value);
            if (!label.isNominal()) continue;
            int i = 0;
            while (i < this.confidences.length) {
                example.setConfidence(predictedLabelAttribute.getMapping().mapIndex(i), this.confidences[i]);
                ++i;
            }
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + Tools.getLineSeparator() + "default value: " + (this.getLabel().isNominal() ? this.getLabel().getMapping().mapIndex((int)this.value) : String.valueOf(this.value));
    }
}

