/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.lazy;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.learner.PredictionModel;

public class AverageModel
extends PredictionModel {
    public AverageModel() {
    }

    public AverageModel(Attribute label) {
        super(label);
    }

    public void performPrediction(ExampleSet exampleSet, Attribute predictedLabelAttribute) {
        for (Example example : exampleSet) {
            double average = 0.0;
            for (Attribute attribute : example.getAttributes()) {
                average += example.getValue(attribute);
            }
            average /= (double)example.getAttributes().size();
            if (predictedLabelAttribute.isNominal()) {
                double minDistance = Double.POSITIVE_INFINITY;
                int prediction = -1;
                for (String classValue : predictedLabelAttribute.getMapping().getValues()) {
                    int classIndex = predictedLabelAttribute.getMapping().mapString(classValue);
                    double distance = Math.abs((double)classIndex - average);
                    if (!(distance < minDistance)) continue;
                    minDistance = distance;
                    prediction = classIndex;
                }
                example.setValue(predictedLabelAttribute, prediction);
                example.setConfidence(predictedLabelAttribute.getMapping().mapIndex(prediction), 1.0);
                continue;
            }
            example.setValue(predictedLabelAttribute, average);
        }
    }
}

