/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel.evosvm;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.EvoOptimization;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.EvoSVMModel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.Kernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.OptimizationFunction;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.RegressionOptimizationFunction;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.SupportVector;
import edu.udo.cs.yale.operator.performance.EstimatedPerformance;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.RandomGenerator;
import edu.udo.cs.yale.tools.math.optimization.ec.es.ESOptimization;
import edu.udo.cs.yale.tools.math.optimization.ec.es.Individual;
import java.util.ArrayList;
import java.util.Iterator;

public class RegressionEvoOptimization
extends ESOptimization
implements EvoOptimization {
    private ExampleSet exampleSet;
    private Kernel kernel;
    private double[] ys;
    private OptimizationFunction optimizationFunction;

    public RegressionEvoOptimization(ExampleSet exampleSet, Kernel kernel, double c, double epsilon, int initType, int maxIterations, int generationsWithoutImprovement, int popSize, int selectionType, double tournamentFraction, boolean keepBest, int mutationType, double crossoverProb, boolean showPlot, RandomGenerator random) {
        super(0.0, RegressionEvoOptimization.determineC(c, kernel, exampleSet), popSize, 2 * exampleSet.size(), initType, maxIterations, generationsWithoutImprovement, selectionType, tournamentFraction, keepBest, mutationType, crossoverProb, showPlot, random);
        this.exampleSet = exampleSet;
        this.kernel = kernel;
        this.ys = new double[exampleSet.size()];
        Iterator reader = exampleSet.iterator();
        int index = 0;
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            this.ys[index++] = example.getLabel();
        }
        this.optimizationFunction = new RegressionOptimizationFunction(epsilon);
    }

    private static final double determineC(double _c, Kernel kernel, ExampleSet exampleSet) {
        kernel.init(exampleSet);
        if (_c <= 0.0) {
            double c = 0.0;
            int i = 0;
            while (i < exampleSet.size()) {
                c += kernel.getDistance(i, i);
                ++i;
            }
            c = (double)exampleSet.size() / c;
            LogService.logMessage("Determine probably good value for C: set to " + c, 2);
            return c;
        }
        return _c;
    }

    public PerformanceVector evaluateIndividual(Individual individual) {
        double[] fitness = this.optimizationFunction.getFitness(individual.getValues(), this.ys, this.kernel);
        PerformanceVector performanceVector = new PerformanceVector();
        performanceVector.addCriterion(new EstimatedPerformance("SVM_fitness", fitness[0], 1, false));
        performanceVector.addCriterion(new EstimatedPerformance("SVM_complexity", fitness[1], 1, false));
        return performanceVector;
    }

    public EvoSVMModel train() throws OperatorException {
        this.optimize();
        return this.getModel(this.getBestValuesEver());
    }

    public PerformanceVector getOptimizationPerformance() {
        double[] bestValuesEver = this.getBestValuesEver();
        double[] finalFitness = this.optimizationFunction.getFitness(bestValuesEver, this.ys, this.kernel);
        PerformanceVector result = new PerformanceVector();
        result.addCriterion(new EstimatedPerformance("svm_objective_function", finalFitness[0], 1, false));
        result.addCriterion(new EstimatedPerformance("no_support_vectors", -1.0 * finalFitness[1], 1, true));
        return result;
    }

    private EvoSVMModel getModel(double[] alphas) {
        Iterator reader = this.exampleSet.iterator();
        ArrayList<SupportVector> supportVectors = new ArrayList<SupportVector>();
        int index = 0;
        while (reader.hasNext()) {
            double currentAlpha = alphas[index];
            Example currentExample = (Example)reader.next();
            if (currentAlpha != 0.0) {
                double[] x = new double[this.exampleSet.getAttributes().size()];
                int a = 0;
                for (Attribute attribute : this.exampleSet.getAttributes()) {
                    x[a++] = currentExample.getValue(attribute);
                }
                supportVectors.add(new SupportVector(x, this.ys[index], currentAlpha));
            }
            ++index;
        }
        double[] sum = new double[this.exampleSet.size()];
        reader = this.exampleSet.iterator();
        index = 0;
        while (reader.hasNext()) {
            Example current = (Example)reader.next();
            double[] x = new double[this.exampleSet.getAttributes().size()];
            int a = 0;
            for (Attribute attribute : this.exampleSet.getAttributes()) {
                x[a++] = current.getValue(attribute);
            }
            sum[index] = this.kernel.getSum(supportVectors, x);
            ++index;
        }
        double bSum = 0.0;
        boolean bCounter = true;
        return new EvoSVMModel(this.exampleSet.getAttributes().getLabel(), supportVectors, this.kernel, bSum / (double)bCounter);
    }
}

