/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel.evosvm;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.learner.AbstractLearner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.Kernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.PSOSVMOptimization;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.PolynomialKernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.RBFKernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.SigmoidKernel;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSOSVM
extends AbstractLearner {
    public PSOSVM(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label.getMapping().size() != 2) {
            throw new UserError((Operator)this, 114, this.getName(), (Object)label.getName());
        }
        int kernelType = this.getParameterAsInt("kernel_type");
        Kernel kernel = Kernel.createKernel(kernelType);
        if (kernelType == 1) {
            double gamma = this.getParameterAsDouble("kernel_gamma");
            ((RBFKernel)kernel).setGamma(gamma);
        } else if (kernelType == 2) {
            ((PolynomialKernel)kernel).setPolynomialParameters(this.getParameterAsInt("kernel_degree"), this.getParameterAsDouble("kernel_shift"));
        } else if (kernelType == 3) {
            ((SigmoidKernel)kernel).setSigmoidParameters(this.getParameterAsDouble("kernel_a"), this.getParameterAsDouble("kernel_b"));
        }
        PSOSVMOptimization optimization = new PSOSVMOptimization(exampleSet, kernel, this.getParameterAsDouble("C"), this.getParameterAsInt("max_evaluations"), this.getParameterAsInt("generations_without_improval"), this.getParameterAsInt("population_size"), this.getParameterAsDouble("inertia_weight"), this.getParameterAsDouble("local_best_weight"), this.getParameterAsDouble("global_best_weight"), this.getParameterAsBoolean("dynamic_inertia_weight"), this.getParameterAsBoolean("show_convergence_plot"), RandomGenerator.getRandomGenerator(this.getParameterAsInt("local_random_seed")));
        optimization.optimize();
        double[] bestAlphas = optimization.getBestValuesEver();
        return optimization.getModel(bestAlphas);
    }

    @Override
    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        return lc == LearnerCapability.BINOMINAL_CLASS;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("show_convergence_plot", "Indicates if a dialog with a convergence plot should be drawn.", false));
        ParameterTypeSingle type = new ParameterTypeCategory("kernel_type", "The SVM kernel type", Kernel.KERNEL_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_gamma", "The SVM kernel parameter sigma (radial kernel).", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_degree", "The SVM kernel parameter degree (polynomial).", 0.0, Double.POSITIVE_INFINITY, 3.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_shift", "The SVM kernel parameter shift (polynomial).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_a", "The SVM kernel parameter a (neural).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_b", "The SVM kernel parameter b (neural).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("C", "The SVM complexity constant (0: calculates probably good value).", 0.0, Double.POSITIVE_INFINITY, 0.0);
        types.add(type);
        types.add(new ParameterTypeInt("max_evaluations", "Stop after this many evaluations", 1, Integer.MAX_VALUE, 500));
        types.add(new ParameterTypeInt("generations_without_improval", "Stop after this number of generations without improvement (-1: optimize until max_iterations).", -1, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeInt("population_size", "The population size (-1: number of examples)", -1, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeDouble("inertia_weight", "The (initial) weight for the old weighting.", 0.0, Double.POSITIVE_INFINITY, 0.1));
        types.add(new ParameterTypeDouble("local_best_weight", "The weight for the individual's best position during run.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeDouble("global_best_weight", "The weight for the population's best position during run.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeBoolean("dynamic_inertia_weight", "If set to true the inertia weight is improved during run.", true));
        types.add(new ParameterTypeInt("local_random_seed", "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

