/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel.evosvm;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.DotKernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.EpanechnikovKernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.EvoSVM;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.GaussianCombinationKernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.MultiquadricKernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.PolynomialKernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.RBFKernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.SigmoidKernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.SupportVector;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Iterator;

public abstract class Kernel {
    public static final String[] KERNEL_TYPES = new String[]{"dot", "radial", "polynomial", "sigmoid", "epanechnikov", "gausian_combination", "multiquadric"};
    public static final int KERNEL_DOT = 0;
    public static final int KERNEL_RADIAL = 1;
    public static final int KERNEL_POLYNOMIAL = 2;
    public static final int KERNEL_SIGMOID = 3;
    public static final int KERNEL_EPANECHNIKOV = 4;
    public static final int KERNEL_GAUSSIAN_COMBINATION = 5;
    public static final int KERNEL_MULTIQUADRIC = 6;
    private double[][] distances;

    public abstract int getType();

    public abstract double calculateDistance(double[] var1, double[] var2);

    public abstract void writeKernelParameters(ObjectOutputStream var1) throws IOException;

    public abstract void readKernelParameters(ObjectInputStream var1) throws IOException;

    public void init(ExampleSet exampleSet) {
        int size = exampleSet.size();
        this.distances = new double[size][size];
        Iterator reader = exampleSet.iterator();
        int i = 0;
        while (reader.hasNext()) {
            Example example1 = (Example)reader.next();
            double[] x1 = new double[exampleSet.getAttributes().size()];
            int x = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                x1[x++] = example1.getValue(attribute);
            }
            Iterator innerReader = exampleSet.iterator();
            int j = 0;
            while (innerReader.hasNext()) {
                double distance;
                Example example2 = (Example)innerReader.next();
                double[] x2 = new double[exampleSet.getAttributes().size()];
                x = 0;
                for (Attribute attribute : exampleSet.getAttributes()) {
                    x2[x++] = example2.getValue(attribute);
                }
                this.distances[i][j] = distance = this.calculateDistance(x1, x2);
                this.distances[j][i] = distance;
                ++j;
            }
            ++i;
        }
    }

    public double getDistance(int x1, int x2) {
        return this.distances[x1][x2];
    }

    public double innerProduct(double[] x1, double[] x2) {
        double result = 0.0;
        int i = 0;
        while (i < x1.length) {
            result += x1[i] * x2[i];
            ++i;
        }
        return result;
    }

    public double norm2(double[] x1, double[] x2) {
        double result = 0.0;
        int i = 0;
        while (i < x1.length) {
            double factor = x1[i] - x2[i];
            result += factor * factor;
            ++i;
        }
        return result;
    }

    public double getSum(Collection supportVectors, double[] currentX) {
        double sum = 0.0;
        for (SupportVector sv : supportVectors) {
            sum += sv.getY() * sv.getAlpha() * this.calculateDistance(sv.getX(), currentX);
        }
        return sum;
    }

    public void writeKernelData(ObjectOutputStream out) throws IOException {
        out.writeInt(this.getType());
        this.writeKernelParameters(out);
    }

    public static Kernel readKernelData(ObjectInputStream in) throws IOException {
        int type = in.readInt();
        Kernel kernel = Kernel.createKernel(type);
        kernel.readKernelParameters(in);
        return kernel;
    }

    public static Kernel createKernel(int kernelType) {
        try {
            return Kernel.createKernel(kernelType, null);
        }
        catch (UndefinedParameterError e) {
            return null;
        }
    }

    public static Kernel createKernel(int kernelType, EvoSVM operator) throws UndefinedParameterError {
        if (kernelType == 0) {
            return new DotKernel();
        }
        if (kernelType == 1) {
            RBFKernel kernel = new RBFKernel();
            if (operator != null) {
                kernel.setGamma(operator.getParameterAsDouble("kernel_gamma"));
            }
            return kernel;
        }
        if (kernelType == 2) {
            PolynomialKernel kernel = new PolynomialKernel();
            if (operator != null) {
                kernel.setPolynomialParameters(operator.getParameterAsDouble("kernel_degree"), operator.getParameterAsDouble("kernel_shift"));
            }
            return kernel;
        }
        if (kernelType == 3) {
            SigmoidKernel kernel = new SigmoidKernel();
            if (operator != null) {
                kernel.setSigmoidParameters(operator.getParameterAsDouble("kernel_a"), operator.getParameterAsDouble("kernel_b"));
            }
            return kernel;
        }
        if (kernelType == 4) {
            EpanechnikovKernel kernel = new EpanechnikovKernel();
            if (operator != null) {
                kernel.setSigma(operator.getParameterAsDouble("kernel_sigma1"));
                kernel.setDegree(operator.getParameterAsDouble("kernel_degree"));
            }
            return kernel;
        }
        if (kernelType == 5) {
            GaussianCombinationKernel kernel = new GaussianCombinationKernel();
            if (operator != null) {
                kernel.setSigma1(operator.getParameterAsDouble("kernel_sigma1"));
                kernel.setSigma2(operator.getParameterAsDouble("kernel_sigma2"));
                kernel.setSigma3(operator.getParameterAsDouble("kernel_sigma3"));
            }
            return kernel;
        }
        if (kernelType == 6) {
            MultiquadricKernel kernel = new MultiquadricKernel();
            if (operator != null) {
                kernel.setSigma(operator.getParameterAsDouble("kernel_sigma1"));
                kernel.setShift(operator.getParameterAsDouble("kernel_shift"));
            }
            return kernel;
        }
        return null;
    }
}

