/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel.evosvm;

import edu.udo.cs.yale.operator.learner.kernel.evosvm.Kernel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class GaussianCombinationKernel
extends Kernel {
    private double sigma1 = 1.0;
    private double sigma2 = 0.0;
    private double sigma3 = 2.0;

    public int getType() {
        return 5;
    }

    public void setSigma1(double sigma1) {
        this.sigma1 = sigma1;
    }

    public void setSigma2(double sigma2) {
        this.sigma2 = sigma2;
    }

    public void setSigma3(double sigma3) {
        this.sigma3 = sigma3;
    }

    public double getSigma1() {
        return this.sigma1;
    }

    public double getSigma2() {
        return this.sigma2;
    }

    public double getSigma3() {
        return this.sigma3;
    }

    public double calculateDistance(double[] x1, double[] x2) {
        double norm2 = this.norm2(x1, x2);
        double exp1 = this.sigma1 == 0.0 ? 0.0 : Math.exp(-1.0 * norm2 / this.sigma1);
        double exp2 = this.sigma2 == 0.0 ? 0.0 : Math.exp(-1.0 * norm2 / this.sigma2);
        double exp3 = this.sigma3 == 0.0 ? 0.0 : Math.exp(-1.0 * norm2 / this.sigma3);
        return exp1 + exp2 - exp3;
    }

    public void readKernelParameters(ObjectInputStream in) throws IOException {
        this.sigma1 = in.readDouble();
        this.sigma2 = in.readDouble();
        this.sigma3 = in.readDouble();
    }

    public void writeKernelParameters(ObjectOutputStream out) throws IOException {
        out.writeDouble(this.sigma1);
        out.writeDouble(this.sigma2);
        out.writeDouble(this.sigma3);
    }
}

