/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel.evosvm;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.learner.kernel.KernelModel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.Kernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.SupportVector;
import edu.udo.cs.yale.tools.Tools;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvoSVMModel
extends KernelModel {
    private Kernel kernel;
    private List<SupportVector> supportVectors;
    private double bias;
    private int numberOfAttributes;

    public EvoSVMModel() {
    }

    public EvoSVMModel(Attribute label) {
        super(label);
    }

    public EvoSVMModel(Attribute label, List<SupportVector> supportVectors, Kernel kernel, double bias) {
        super(label);
        this.supportVectors = supportVectors;
        if (supportVectors == null || supportVectors.size() == 0) {
            throw new IllegalArgumentException("Null or empty support vector collection: not possible to predict values!");
        }
        this.numberOfAttributes = supportVectors.get(0).getX().length;
        this.kernel = kernel;
        this.bias = bias;
    }

    @Override
    public String getModelInfo() {
        return "SVM Model (" + this.supportVectors.size() + " support vectors, bias: " + this.bias + ")";
    }

    @Override
    public boolean isClassificationModel() {
        return this.getLabel().isNominal();
    }

    @Override
    public double getAlpha(int index) {
        return this.supportVectors.get(index).getAlpha();
    }

    @Override
    public String getId(int index) {
        return null;
    }

    @Override
    public int getNumberOfExamples() {
        return this.supportVectors.size();
    }

    @Override
    public int getNumberOfAttributes() {
        return this.supportVectors.get(0).getX().length;
    }

    @Override
    public double getAttributeValue(int exampleIndex, int attributeIndex) {
        return this.supportVectors.get(exampleIndex).getX()[attributeIndex];
    }

    @Override
    public String getClassificationLabel(int index) {
        double y = this.getRegressionLabel(index);
        if (y < 0.0) {
            return this.getLabel().getMapping().getNegativeString();
        }
        return this.getLabel().getMapping().getPositiveString();
    }

    @Override
    public double getRegressionLabel(int index) {
        return this.supportVectors.get(index).getY();
    }

    @Override
    public double getFunctionValue(int index) {
        double[] values = this.supportVectors.get(index).getX();
        return this.bias + this.kernel.getSum(this.supportVectors, values);
    }

    @Override
    public void performPrediction(ExampleSet exampleSet, Attribute predLabel) {
        if (exampleSet.getAttributes().size() != this.numberOfAttributes) {
            throw new RuntimeException("Cannot apply model: incompatible numbers of attributes (" + exampleSet.getAttributes().size() + " != " + this.numberOfAttributes + ")!");
        }
        for (Example current : exampleSet) {
            double[] currentX = new double[exampleSet.getAttributes().size()];
            int x = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                currentX[x++] = current.getValue(attribute);
            }
            double sum = this.bias + this.kernel.getSum(this.supportVectors, currentX);
            if (this.getLabel().isNominal()) {
                int index = sum > 0.0 ? this.getLabel().getMapping().getPositiveIndex() : this.getLabel().getMapping().getNegativeIndex();
                current.setValue(predLabel, index);
                current.setConfidence(predLabel.getMapping().getPositiveString(), 1.0 / (1.0 + Math.exp(-sum)));
                current.setConfidence(predLabel.getMapping().getNegativeString(), 1.0 / (1.0 + Math.exp(sum)));
                continue;
            }
            current.setValue(predLabel, sum);
        }
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer("EvoSVM Model" + Tools.getLineSeparator());
        result.append("#SV: " + this.supportVectors.size() + Tools.getLineSeparator());
        result.append("b: " + this.bias + Tools.getLineSeparator());
        double[] w = new double[this.numberOfAttributes];
        for (SupportVector sv : this.supportVectors) {
            double[] x = sv.getX();
            double alpha = sv.getAlpha();
            double y = sv.getY();
            int j = 0;
            while (j < w.length) {
                w[j] = y * alpha * x[j];
                ++j;
            }
        }
        int j = 0;
        while (j < w.length) {
            result.append("w[" + j + "]=" + w[j] + Tools.getLineSeparator());
            ++j;
        }
        Iterator<SupportVector> i = this.supportVectors.iterator();
        int index = 0;
        while (i.hasNext()) {
            if (index > 100) {
                result.append("... " + (this.supportVectors.size() - 100) + " SVs ...");
                break;
            }
            result.append(i.next() + Tools.getLineSeparator());
        }
        return result.toString();
    }
}

