/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel.evosvm;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.learner.AbstractLearner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.EvoOptimization;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.Kernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.PatternEvoOptimization;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.RegressionEvoOptimization;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.RandomGenerator;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.math.optimization.ec.es.ESOptimization;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvoSVM
extends AbstractLearner {
    private EvoOptimization optimization;

    public EvoSVM(OperatorDescription description) {
        super(description);
    }

    @Override
    public boolean shouldDeliverOptimizationPerformance() {
        return this.getParameterAsBoolean("return_optimization_performance");
    }

    @Override
    public PerformanceVector getOptimizationPerformance() {
        return this.optimization.getOptimizationPerformance();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        int kernelType = this.getParameterAsInt("kernel_type");
        Kernel kernel = Kernel.createKernel(kernelType, this);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt("local_random_seed"));
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label.isNominal()) {
            if (label.getMapping().size() != 2) throw new UserError((Operator)this, 114, this.getName(), (Object)label.getName());
            ExampleSet holdOutSet = null;
            ExampleSet trainingSet = exampleSet;
            double holdOutSetRatio = this.getParameterAsDouble("hold_out_set_ratio");
            if (!Tools.isZero(holdOutSetRatio)) {
                SplittedExampleSet splittedExampleSet = new SplittedExampleSet(exampleSet, new double[]{1.0 - holdOutSetRatio, holdOutSetRatio}, 1, 2001);
                splittedExampleSet.selectSingleSubset(0);
                trainingSet = (ExampleSet)splittedExampleSet.clone();
                splittedExampleSet.selectAllSubsetsBut(0);
                holdOutSet = (ExampleSet)splittedExampleSet.clone();
            }
            this.optimization = new PatternEvoOptimization(trainingSet, kernel, this.getParameterAsDouble("C"), this.getParameterAsInt("start_population_type"), this.getParameterAsInt("max_generations"), this.getParameterAsInt("generations_without_improval"), this.getParameterAsInt("population_size"), this.getParameterAsInt("selection_type"), this.getParameterAsDouble("tournament_fraction"), this.getParameterAsBoolean("keep_best"), this.getParameterAsInt("mutation_type"), this.getParameterAsDouble("crossover_prob"), this.getParameterAsBoolean("show_convergence_plot"), holdOutSet, random);
            return this.optimization.train();
        } else {
            this.optimization = new RegressionEvoOptimization(exampleSet, kernel, this.getParameterAsDouble("C"), this.getParameterAsDouble("epsilon"), this.getParameterAsInt("start_population_type"), this.getParameterAsInt("max_generations"), this.getParameterAsInt("generations_without_improval"), this.getParameterAsInt("population_size"), this.getParameterAsInt("selection_type"), this.getParameterAsDouble("tournament_fraction"), this.getParameterAsBoolean("keep_best"), this.getParameterAsInt("mutation_type"), this.getParameterAsDouble("crossover_prob"), this.getParameterAsBoolean("show_convergence_plot"), random);
        }
        return this.optimization.train();
    }

    @Override
    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.BINOMINAL_CLASS) {
            return true;
        }
        return lc == LearnerCapability.NUMERICAL_CLASS;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory("kernel_type", "The SVM kernel type", Kernel.KERNEL_TYPES, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_gamma", "The SVM kernel parameter gamma (RBF).", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_sigma1", "The SVM kernel parameter sigma1 (Epanechnikov, Gaussian Combination, Multiquadric).", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_sigma2", "The SVM kernel parameter sigma2 (Gaussian Combination).", 0.0, Double.POSITIVE_INFINITY, 0.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_sigma3", "The SVM kernel parameter sigma3 (Gaussian Combination).", 0.0, Double.POSITIVE_INFINITY, 2.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_degree", "The SVM kernel parameter degree (polynomial, Epanechnikov).", 0.0, Double.POSITIVE_INFINITY, 3.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_shift", "The SVM kernel parameter shift (polynomial, Multiquadric).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_a", "The SVM kernel parameter a (neural).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_b", "The SVM kernel parameter b (neural).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("C", "The SVM complexity constant (0: calculates probably good value).", 0.0, Double.POSITIVE_INFINITY, 0.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("epsilon", "The width of the regression tube loss function of the regression SVM", 0.0, Double.POSITIVE_INFINITY, 0.1);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory("start_population_type", "The type of start population initialization.", ESOptimization.POPULATION_INIT_TYPES, 0));
        types.add(new ParameterTypeInt("max_generations", "Stop after this many evaluations", 1, Integer.MAX_VALUE, 10000));
        types.add(new ParameterTypeInt("generations_without_improval", "Stop after this number of generations without improvement (-1: optimize until max_iterations).", -1, Integer.MAX_VALUE, 30));
        types.add(new ParameterTypeInt("population_size", "The population size (-1: number of examples)", -1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeDouble("tournament_fraction", "The fraction of the population used for tournament selection.", 0.0, Double.POSITIVE_INFINITY, 0.75));
        types.add(new ParameterTypeBoolean("keep_best", "Indicates if the best individual should survive (elititst selection).", true));
        types.add(new ParameterTypeCategory("mutation_type", "The type of the mutation operator.", ESOptimization.MUTATION_TYPES, 1));
        types.add(new ParameterTypeCategory("selection_type", "The type of the selection operator.", ESOptimization.SELECTION_TYPES, 6));
        types.add(new ParameterTypeDouble("crossover_prob", "The probability for crossovers.", 0.0, 1.0, 1.0));
        types.add(new ParameterTypeInt("local_random_seed", "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeDouble("hold_out_set_ratio", "Uses this amount as a hold out set to estimate generalization error after learning (currently only used for multi-objective classification).", 0.0, 1.0, 0.0));
        types.add(new ParameterTypeBoolean("show_convergence_plot", "Indicates if a dialog with a convergence plot should be drawn.", false));
        types.add(new ParameterTypeBoolean("return_optimization_performance", "Indicates if final optimization fitness should be returned as performance.", false));
        return types;
    }
}

