/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel.evosvm;

import edu.udo.cs.yale.operator.learner.kernel.evosvm.Kernel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class EpanechnikovKernel
extends Kernel {
    private double sigma = 1.0;
    private double degree = 1.0;

    public int getType() {
        return 4;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    public double getSigma() {
        return this.sigma;
    }

    public double getDegree() {
        return this.degree;
    }

    public void setDegree(double degree) {
        this.degree = degree;
    }

    public double calculateDistance(double[] x1, double[] x2) {
        double expression = this.norm2(x1, x2) / this.sigma;
        if (expression > 1.0) {
            return 0.0;
        }
        double minus = 1.0 - expression;
        return Math.pow(minus, this.degree);
    }

    public void readKernelParameters(ObjectInputStream in) throws IOException {
        this.sigma = in.readDouble();
        this.degree = in.readDouble();
    }

    public void writeKernelParameters(ObjectOutputStream out) throws IOException {
        out.writeDouble(this.sigma);
        out.writeDouble(this.degree);
    }
}

