/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel.evosvm;

import edu.udo.cs.yale.operator.learner.kernel.evosvm.Kernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.OptimizationFunction;

public class ClassificationOptimizationFunction
implements OptimizationFunction {
    private boolean multiobjective;

    public ClassificationOptimizationFunction(boolean multiobjective) {
        this.multiobjective = multiobjective;
    }

    public double[] getFitness(double[] alphas, double[] ys, Kernel kernel) {
        double sum = 0.0;
        double alphaLabelSum = 0.0;
        int numberSV = 0;
        int i = 0;
        while (i < ys.length) {
            sum += alphas[i];
            alphaLabelSum += ys[i] * alphas[i];
            if (alphas[i] > 0.0) {
                ++numberSV;
            }
            ++i;
        }
        double matrixSum = 0.0;
        int i2 = 0;
        while (i2 < ys.length) {
            if (alphas[i2] != 0.0) {
                int j = 0;
                while (j < ys.length) {
                    if (alphas[j] != 0.0) {
                        matrixSum += alphas[i2] * alphas[j] * ys[i2] * ys[j] * kernel.getDistance(i2, j);
                    }
                    ++j;
                }
            }
            ++i2;
        }
        alphaLabelSum = -Math.abs(alphaLabelSum);
        if (this.multiobjective) {
            return new double[]{sum, -matrixSum, alphaLabelSum};
        }
        return new double[]{sum - 0.5 * matrixSum};
    }
}

