/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.FastExample2SparseTransform;
import edu.udo.cs.yale.operator.learner.kernel.KernelModel;
import edu.udo.cs.yale.operator.learner.kernel.LibSVMLearner;
import edu.udo.cs.yale.tools.Tools;
import libsvm.Svm;
import libsvm.svm_model;
import libsvm.svm_node;

public class LibSVMModel
extends KernelModel {
    private svm_model model;
    private int numberOfAttributes;

    public LibSVMModel() {
    }

    public LibSVMModel(Attribute label) {
        super(label);
    }

    public LibSVMModel(Attribute label, svm_model model, int numberOfAttributes) {
        super(label);
        this.model = model;
        this.numberOfAttributes = numberOfAttributes;
    }

    public String getModelInfo() {
        return "SVM Model (" + this.model.l + " support vectors)";
    }

    public boolean isClassificationModel() {
        return this.getLabel().isNominal();
    }

    public double getAlpha(int index) {
        return this.model.sv_coef[0][index];
    }

    public String getId(int index) {
        return null;
    }

    public int getNumberOfExamples() {
        return this.model.SV.length;
    }

    public int getNumberOfAttributes() {
        return this.numberOfAttributes;
    }

    public double getAttributeValue(int exampleIndex, int attributeIndex) {
        double[] dense = new double[this.numberOfAttributes];
        svm_node[] node = this.model.SV[exampleIndex];
        int i = 0;
        while (i < node.length) {
            dense[node[i].index] = node[i].value;
            ++i;
        }
        return dense[attributeIndex];
    }

    public String getClassificationLabel(int index) {
        double functionValue = this.getRegressionLabel(index);
        if (!Double.isNaN(functionValue)) {
            return this.getLabel().getMapping().mapIndex((int)functionValue);
        }
        return "?";
    }

    public double getRegressionLabel(int index) {
        if (this.model.labelValues != null) {
            return this.model.labelValues[index];
        }
        return Double.NaN;
    }

    public double getFunctionValue(int index) {
        if (this.getLabel().isNominal()) {
            double[] classProbs = new double[this.getLabel().getMapping().size()];
            Svm.svm_predict_probability(this.model, this.model.SV[index], classProbs);
            return classProbs[0];
        }
        return Svm.svm_predict(this.model, this.model.SV[index]);
    }

    public void performPrediction(ExampleSet exampleSet, Attribute predictedLabel) {
        FastExample2SparseTransform ripper = new FastExample2SparseTransform(exampleSet);
        for (Example e : exampleSet) {
            if (this.getLabel().isNominal()) {
                double[] classProbs = new double[this.model.label.length];
                double value = Svm.svm_predict_probability(this.model, LibSVMLearner.makeNodes(e, ripper), classProbs);
                e.setValue(predictedLabel, value);
                int k = 0;
                while (k < this.model.label.length) {
                    e.setConfidence(this.getLabel().getMapping().mapIndex(this.model.label[k]), classProbs[k]);
                    ++k;
                }
                continue;
            }
            e.setValue(predictedLabel, Svm.svm_predict(this.model, LibSVMLearner.makeNodes(e, ripper)));
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(String.valueOf(super.toString()) + Tools.getLineSeparator());
        result.append("number of classes: " + this.model.nr_class + Tools.getLineSeparator());
        if (this.getLabel().isNominal()) {
            int i = 0;
            while (i < this.model.nSV.length) {
                result.append("number of support vectors for class " + this.getLabel().getMapping().mapIndex(this.model.label[i]) + ": " + this.model.nSV[i] + Tools.getLineSeparator());
                ++i;
            }
        } else {
            result.append("number of support vectors: " + this.model.l + Tools.getLineSeparator());
        }
        return result.toString();
    }
}

