/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.FastExample2SparseTransform;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.learner.AbstractLearner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.kernel.LibSVMModel;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.performance.EstimatedPerformance;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import libsvm.Kernel;
import libsvm.Svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;
import libsvm.svm_problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibSVMLearner
extends AbstractLearner {
    public static final String[] SVM_TYPES = new String[]{"C-SVC", "nu-SVC", "one-class", "epsilon-SVR", "nu-SVR"};
    public static final String[] KERNEL_TYPES = new String[]{"linear", "poly", "rbf", "sigmoid", "epnechnikov"};
    private double lastFitness;
    private int lastNumberSV;

    public LibSVMLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public boolean shouldDeliverOptimizationPerformance() {
        return this.getParameterAsBoolean("return_optimization_performance");
    }

    @Override
    public PerformanceVector getOptimizationPerformance() throws OperatorException {
        PerformanceVector result = new PerformanceVector();
        result.addCriterion(new EstimatedPerformance("svm_objective_function", this.lastFitness, 1, false));
        result.addCriterion(new EstimatedPerformance("no_support_vectors", this.lastNumberSV, 1, true));
        return result;
    }

    private double getFitness(double[] alphas, double[] ys, Kernel kernel) {
        double sum = 0.0;
        int numberSV = 0;
        int i = 0;
        while (i < ys.length) {
            sum += alphas[i];
            if (alphas[i] > 0.0) {
                ++numberSV;
            }
            ++i;
        }
        double matrixSum = 0.0;
        int i2 = 0;
        while (i2 < ys.length) {
            if (alphas[i2] != 0.0) {
                int j = 0;
                while (j < ys.length) {
                    if (alphas[j] != 0.0) {
                        matrixSum += alphas[i2] * alphas[j] * ys[i2] * ys[j] * kernel.kernel_function(i2, j);
                    }
                    ++j;
                }
            }
            ++i2;
        }
        return sum - 0.5 * matrixSum;
    }

    @Override
    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.BINOMINAL_CLASS) {
            return true;
        }
        if (lc == LearnerCapability.POLYNOMINAL_CLASS) {
            return true;
        }
        return lc == LearnerCapability.NUMERICAL_CLASS;
    }

    protected static svm_node[] makeNodes(Example e, FastExample2SparseTransform ripper) {
        int[] nonDefaultIndices = ripper.getNonDefaultAttributeIndices(e);
        double[] nonDefaultValues = ripper.getNonDefaultAttributeValues(e, nonDefaultIndices);
        svm_node[] nodeArray = new svm_node[nonDefaultIndices.length];
        int a = 0;
        while (a < nonDefaultIndices.length) {
            svm_node node = new svm_node();
            node.index = nonDefaultIndices[a];
            node.value = nonDefaultValues[a];
            nodeArray[a] = node;
            ++a;
        }
        return nodeArray;
    }

    private svm_problem getProblem(ExampleSet exampleSet) {
        LogService.logMessage("Creating LibSVM problem.", 0);
        FastExample2SparseTransform ripper = new FastExample2SparseTransform(exampleSet);
        int nodeCount = 0;
        svm_problem problem = new svm_problem();
        problem.l = exampleSet.size();
        problem.y = new double[exampleSet.size()];
        problem.x = new svm_node[exampleSet.size()][];
        Iterator i = exampleSet.iterator();
        int j = 0;
        while (i.hasNext()) {
            Example e = (Example)i.next();
            problem.x[j] = LibSVMLearner.makeNodes(e, ripper);
            problem.y[j] = e.getLabel();
            nodeCount += problem.x[j].length;
            ++j;
        }
        LogService.logMessage("Created " + nodeCount + " nodes for " + j + " examples.", 2);
        return problem;
    }

    private svm_parameter getParameters(ExampleSet exampleSet) throws OperatorException {
        Attribute label;
        svm_parameter params = new svm_parameter();
        params.svm_type = this.getParameterAsInt("svm_type");
        params.kernel_type = this.getParameterAsInt("kernel_type");
        params.degree = this.getParameterAsDouble("degree");
        params.gamma = this.getParameterAsDouble("gamma");
        if (params.gamma == 0.0) {
            params.gamma = 1.0 / (double)exampleSet.size();
        }
        params.coef0 = this.getParameterAsDouble("coef0");
        params.nu = this.getParameterAsDouble("nu");
        params.cache_size = this.getParameterAsInt("cache_size");
        params.C = this.getParameterAsDouble("C");
        params.eps = this.getParameterAsDouble("epsilon");
        params.p = this.getParameterAsDouble("p");
        params.shrinking = this.getParameterAsBoolean("shrinking") ? 1 : 0;
        params.probability = 1;
        if (params.svm_type == 0 && (label = exampleSet.getAttributes().getLabel()).isNominal() && this.isParameterSet("class_weights")) {
            double[] weights = new double[label.getMapping().size()];
            int[] weightLabelIndices = new int[label.getMapping().size()];
            int i = 0;
            while (i < weights.length) {
                weights[i] = 1.0;
                weightLabelIndices[i] = i;
                ++i;
            }
            List classWeights = this.getParameterList("class_weights");
            for (Object[] classWeightArray : classWeights) {
                String className = (String)classWeightArray[0];
                double classWeight = (Double)classWeightArray[1];
                int index = label.getMapping().getIndex(className);
                if (index < 0 || index >= weights.length) continue;
                weights[index] = classWeight;
            }
            LinkedList<Double> weightList = new LinkedList<Double>();
            double[] dArray = weights;
            int n = 0;
            int n2 = dArray.length;
            while (n < n2) {
                double d = dArray[n];
                weightList.add(d);
                ++n;
            }
            LogService.logMessage(String.valueOf(this.getName()) + ": used class weights --> " + weightList, 2);
            params.weight = weights;
            params.nr_weight = weights.length;
            params.weight_label = weightLabelIndices;
        }
        return params;
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        svm_parameter params = this.getParameters(exampleSet);
        svm_problem problem = this.getProblem(exampleSet);
        String errorMsg = Svm.svm_check_parameter(problem, params);
        if (errorMsg != null) {
            throw new UserError((Operator)this, 905, new Object[]{"libsvm", errorMsg});
        }
        LogService.logMessage("Training LibSVM.", 0);
        svm_model model = Svm.svm_train(problem, params);
        double[] alphas = new double[model.l];
        double[] ys = new double[model.l];
        Attribute label = exampleSet.getAttributes().getLabel();
        int i = 0;
        while (i < alphas.length) {
            alphas[i] = model.sv_coef[0][i];
            if (label.isNominal() && label.getMapping().size() == 2) {
                ys[i] = (double)label.getMapping().getPositiveIndex() == model.labelValues[i] ? 1 : -1;
            }
            ++i;
        }
        if (label.isNominal() && label.getMapping().size() != 2) {
            ys = null;
        }
        Kernel kernel = Svm.getGenericKernel(problem, params);
        this.lastFitness = Double.NaN;
        if (ys != null) {
            this.lastFitness = this.getFitness(alphas, ys, kernel);
        }
        this.lastNumberSV = model.l;
        return new LibSVMModel(exampleSet.getAttributes().getLabel(), model, exampleSet.getAttributes().size());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory("svm_type", "SVM for classification (C-SVC, nu-SVC), regression (epsilon-SVR, nu-SVR) and distribution estimation (one-class)", SVM_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory("kernel_type", "The type of the kernel functions", KERNEL_TYPES, 2);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble("degree", "The degree for a polynomial kernel function.", 1.0, Double.POSITIVE_INFINITY, 3.0));
        types.add(new ParameterTypeDouble("gamma", "The parameter gamma for polynomial, rbf, and sigmoid kernel functions (0 means 1/#attributes).", 0.0, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeDouble("coef0", "The parameter coef0 for polynomial and sigmoid kernel functions.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0));
        type = new ParameterTypeDouble("C", "The cost parameter C for c_svc, epsilon_svr, and nu_svr.", 0.0, Double.POSITIVE_INFINITY, 0.0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble("nu", "The parameter nu for nu_svc, one_class, and nu_svr.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.5));
        types.add(new ParameterTypeInt("cache_size", "Cache size in Megabyte.", 0, Integer.MAX_VALUE, 80));
        types.add(new ParameterTypeDouble("epsilon", "Tolerance of termination criterion.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.001));
        types.add(new ParameterTypeDouble("p", "Tolerance of loss function of epsilon-SVR.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.1));
        types.add(new ParameterTypeList("class_weights", "The weights w for all classes (first column: class name, second column: weight), i.e. set the parameters C of each class w * C (empty: using 1 for all classes where the weight was not defined).", new ParameterTypeDouble("weight", "The weight for the specified class.", 0.0, Double.POSITIVE_INFINITY, 1.0)));
        types.add(new ParameterTypeBoolean("shrinking", "Whether to use the shrinking heuristics.", true));
        types.add(new ParameterTypeBoolean("return_optimization_performance", "Indicates if final optimization fitness should be returned as performance.", false));
        return types;
    }
}

