/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel;

import edu.udo.cs.yale.datatable.DataTableKernelModelAdapter;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.gui.plotter.PlotterPanel;
import edu.udo.cs.yale.gui.viewer.DataTableViewer;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.learner.PredictionModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public abstract class KernelModel
extends PredictionModel {
    public KernelModel() {
    }

    public KernelModel(Attribute labelAttribute) {
        super(labelAttribute);
    }

    public abstract String getModelInfo();

    public abstract double getAlpha(int var1);

    public abstract double getFunctionValue(int var1);

    public abstract boolean isClassificationModel();

    public abstract String getClassificationLabel(int var1);

    public abstract double getRegressionLabel(int var1);

    public abstract String getId(int var1);

    public abstract int getNumberOfExamples();

    public abstract int getNumberOfAttributes();

    public abstract double getAttributeValue(int var1, int var2);

    public Component getVisualizationComponent(IOContainer container) {
        final JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        DataTableKernelModelAdapter dataTable = new DataTableKernelModelAdapter(this);
        final DataTableViewer tableViewer = new DataTableViewer(dataTable);
        mainPanel.add((Component)tableViewer, "Center");
        final PlotterPanel plotterPanel = new PlotterPanel(dataTable);
        final JRadioButton tableButton = new JRadioButton("table view", true);
        tableButton.setToolTipText("Toggles to the table view of this model data.");
        tableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (tableButton.isSelected()) {
                    mainPanel.remove(plotterPanel);
                    mainPanel.add((Component)tableViewer, "Center");
                    mainPanel.repaint();
                }
            }
        });
        final JRadioButton plotButton = new JRadioButton("plot view", false);
        plotButton.setToolTipText("Toggles to the plotter view of this model.");
        plotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (plotButton.isSelected()) {
                    mainPanel.remove(tableViewer);
                    mainPanel.add((Component)plotterPanel, "Center");
                    mainPanel.repaint();
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(tableButton);
        group.add(plotButton);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel togglePanel = new JPanel(layout);
        c.fill = 1;
        c.insets = new Insets(3, 3, 3, 3);
        c.gridwidth = 0;
        JLabel modelInfoLabel = new JLabel(this.getModelInfo());
        layout.setConstraints(modelInfoLabel, c);
        togglePanel.add(modelInfoLabel);
        c.gridwidth = -1;
        layout.setConstraints(tableButton, c);
        togglePanel.add(tableButton);
        c.gridwidth = 0;
        layout.setConstraints(plotButton, c);
        togglePanel.add(plotButton);
        mainPanel.add((Component)togglePanel, "North");
        return mainPanel;
    }
}

