/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel;

import edu.udo.cs.mySVM.Examples.ExampleSet;
import edu.udo.cs.mySVM.Kernel.Kernel;
import edu.udo.cs.mySVM.SVM.SVMInterface;
import edu.udo.cs.mySVM.SVM.SVMpattern;
import edu.udo.cs.mySVM.SVM.SVMregression;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.kernel.AbstractMySVMLearner;
import edu.udo.cs.yale.operator.learner.kernel.AbstractMySVMModel;
import edu.udo.cs.yale.operator.learner.kernel.JMySVMModel;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.performance.EstimatedPerformance;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMySVMLearner
extends AbstractMySVMLearner {
    private boolean pattern = true;

    public JMySVMLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.BINOMINAL_CLASS) {
            return true;
        }
        return lc == LearnerCapability.NUMERICAL_CLASS;
    }

    @Override
    public boolean shouldEstimatePerformance() {
        return this.getParameterAsBoolean("estimate_performance");
    }

    @Override
    public PerformanceVector getEstimatedPerformance() throws OperatorException {
        if (!this.pattern) {
            throw new UserError((Operator)this, 912, this, (Object)"Cannot calculate leave one out estimation of error for regression tasks!");
        }
        double[] estVector = ((SVMpattern)this.getSVM()).getXiAlphaEstimation(this.getKernel());
        PerformanceVector pv = new PerformanceVector();
        pv.addCriterion(new EstimatedPerformance("xialpha_error", estVector[0], 1, true));
        pv.addCriterion(new EstimatedPerformance("xialpha_precision", estVector[1], 1, false));
        pv.addCriterion(new EstimatedPerformance("xialpha_recall", estVector[2], 1, false));
        pv.setMainCriterionName("xialpha_error");
        return pv;
    }

    @Override
    public AbstractMySVMModel createSVMModel(Attribute label, ExampleSet exampleSet, Kernel kernel, int kernelType) {
        return new JMySVMModel(label, exampleSet, kernel, kernelType);
    }

    @Override
    public SVMInterface createSVM(Attribute label, Kernel kernel, ExampleSet exampleSet, edu.udo.cs.yale.example.ExampleSet yaleExamples) throws OperatorException {
        if (label.isNominal()) {
            this.pattern = true;
            return new SVMpattern(this, kernel, exampleSet, yaleExamples);
        }
        this.pattern = false;
        return new SVMregression(this, kernel, exampleSet, yaleExamples);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("estimate_performance", "Indicates if this learner should also return a performance estimation.", false));
        types.add(new ParameterTypeDouble("L_pos", "A factor for the SVM complexity constant for positive examples", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeDouble("L_neg", "A factor for the SVM complexity constant for negative examples", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeDouble("epsilon", "Insensitivity constant. No loss if prediction lies this close to true value", 0.0, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeDouble("epsilon+", "Epsilon for positive deviation only", 0.0, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeDouble("epsilon-", "Epsilon for negative deviation only", 0.0, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeBoolean("balance_cost", "Adapts Cpos and Cneg to the relative size of the classes", false));
        types.add(new ParameterTypeBoolean("quadratic_loss_pos", "Use quadratic loss for positive deviation", false));
        types.add(new ParameterTypeBoolean("quadratic_loss_neg", "Use quadratic loss for negative deviation", false));
        return types;
    }
}

