/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel;

import edu.udo.cs.myGP.Model;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.kernel.KernelModel;
import edu.udo.cs.yale.operator.learner.kernel.RVMModel;

public class GPModel
extends KernelModel {
    private Model model = null;

    public GPModel() {
    }

    public GPModel(Attribute label) {
        super(label);
    }

    public GPModel(Attribute label, Model model) {
        super(label);
        this.model = model;
    }

    public String getModelInfo() {
        return "GP Model (" + this.model.getNumberOfBasisVectors() + " basis vectors)";
    }

    public boolean isClassificationModel() {
        return this.getLabel().isNominal();
    }

    public double getAlpha(int index) {
        return Double.NaN;
    }

    public String getId(int index) {
        return null;
    }

    public int getNumberOfExamples() {
        return this.model.getNumberOfBasisVectors();
    }

    public int getNumberOfAttributes() {
        return this.model.getInputDim();
    }

    public double getAttributeValue(int exampleIndex, int attributeIndex) {
        return this.model.getBasisVectorValue(exampleIndex, attributeIndex);
    }

    public String getClassificationLabel(int index) {
        return "?";
    }

    public double getRegressionLabel(int index) {
        return Double.NaN;
    }

    public double getFunctionValue(int index) {
        return this.model.applyToVector(this.model.getBasisVector(index));
    }

    public void performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        for (Example e : exampleSet) {
            double functionValue = this.model.applyToVector(RVMModel.makeInputVector(e));
            if (this.getLabel().isNominal()) {
                if (functionValue > 0.0) {
                    e.setValue(predictedLabel, this.getLabel().getMapping().getPositiveIndex());
                } else {
                    e.setValue(predictedLabel, this.getLabel().getMapping().getNegativeIndex());
                }
                e.setConfidence(predictedLabel.getMapping().getPositiveString(), 1.0 / (1.0 + Math.exp(-functionValue)));
                e.setConfidence(predictedLabel.getMapping().getNegativeString(), 1.0 / (1.0 + Math.exp(functionValue)));
                continue;
            }
            e.setValue(predictedLabel, functionValue);
        }
    }
}

