/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel;

import edu.udo.cs.myGP.Parameter;
import edu.udo.cs.myGP.Regression;
import edu.udo.cs.myGP.RegressionProblem;
import edu.udo.cs.myRVM.Kernel.Kernel;
import edu.udo.cs.myRVM.Kernel.KernelCauchy;
import edu.udo.cs.myRVM.Kernel.KernelEpanechnikov;
import edu.udo.cs.myRVM.Kernel.KernelGaussianCombination;
import edu.udo.cs.myRVM.Kernel.KernelLaplace;
import edu.udo.cs.myRVM.Kernel.KernelMultiquadric;
import edu.udo.cs.myRVM.Kernel.KernelPoly;
import edu.udo.cs.myRVM.Kernel.KernelRadial;
import edu.udo.cs.myRVM.Kernel.KernelSigmoid;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.learner.AbstractLearner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.kernel.GPModel;
import edu.udo.cs.yale.operator.learner.kernel.RVMModel;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.tools.LogService;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPLearner
extends AbstractLearner {
    public static final String[] KERNEL_TYPES = new String[]{"rbf", "cauchy", "laplace", "poly", "sigmoid", "Epanechnikov", "gaussian combination", "multiquadric"};

    public GPLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.BINOMINAL_CLASS) {
            return true;
        }
        if (lc == LearnerCapability.POLYNOMINAL_CLASS) {
            return true;
        }
        return lc == LearnerCapability.NUMERICAL_CLASS;
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        LogService.logMessage("Creating GP-Learner.", 2);
        Parameter parameter = new Parameter();
        int numExamples = exampleSet.size();
        parameter.maxBasisVectors = this.getParameterAsInt("max_basis_vectors");
        parameter.epsilon_tol = this.getParameterAsDouble("epsilon_tol");
        parameter.geometrical_tol = this.getParameterAsDouble("geometrical_tol");
        LogService.logMessage("=> Creating input / output vectors.", 2);
        double[][] x = new double[numExamples][exampleSet.getAttributes().size()];
        double[][] t = new double[numExamples][1];
        Iterator reader = exampleSet.iterator();
        int k = 0;
        while (reader.hasNext()) {
            double[] targetVector = new double[1];
            Example e = (Example)reader.next();
            targetVector[0] = e.getLabel();
            x[k] = RVMModel.makeInputVector(e);
            t[k] = targetVector;
            ++k;
        }
        Attribute label = exampleSet.getAttributes().getLabel();
        LogService.logMessage("=> Creating kernel.", 2);
        Kernel kernel = this.createKernel();
        edu.udo.cs.myGP.Model model = null;
        if (label.isNominal()) {
            throw new UserError((Operator)this, 102, this.getName(), (Object)label.getName());
        }
        RegressionProblem problem = new RegressionProblem(x, t, kernel);
        Regression GP = new Regression(problem, parameter);
        try {
            model = GP.learn();
        }
        catch (Exception e) {
            throw new OperatorException(e.getMessage());
        }
        GPModel yaleModel = new GPModel(exampleSet.getAttributes().getLabel(), model);
        return yaleModel;
    }

    public Kernel createKernel() throws OperatorException {
        Kernel kernel = null;
        double lengthScale = this.getParameterAsDouble("kernel_lengthscale");
        double bias = this.getParameterAsDouble("kernel_bias");
        double degree = this.getParameterAsDouble("kernel_degree");
        double a = this.getParameterAsDouble("kernel_a");
        double b = this.getParameterAsDouble("kernel_b");
        double sigma1 = this.getParameterAsDouble("kernel_sigma1");
        double sigma2 = this.getParameterAsDouble("kernel_sigma2");
        double sigma3 = this.getParameterAsDouble("kernel_sigma3");
        double shift = this.getParameterAsDouble("kernel_shift");
        switch (this.getParameterAsInt("kernel_type")) {
            case 0: {
                kernel = new KernelRadial(lengthScale);
                break;
            }
            case 1: {
                kernel = new KernelCauchy(lengthScale);
                break;
            }
            case 2: {
                kernel = new KernelLaplace(lengthScale);
                break;
            }
            case 3: {
                kernel = new KernelPoly(lengthScale, bias, degree);
                break;
            }
            case 4: {
                kernel = new KernelSigmoid(a, b);
                break;
            }
            case 5: {
                kernel = new KernelEpanechnikov(sigma1, degree);
                break;
            }
            case 6: {
                kernel = new KernelGaussianCombination(sigma1, sigma2, sigma3);
                break;
            }
            case 7: {
                kernel = new KernelMultiquadric(sigma1, shift);
                break;
            }
            default: {
                kernel = new KernelRadial(lengthScale);
            }
        }
        return kernel;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory("kernel_type", "The kind of kernel.", KERNEL_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_lengthscale", "The lengthscale r for rbf kernel functions (exp{-1.0 * r^-2 * ||x - bla||}).", 0.0, Double.POSITIVE_INFINITY, 3.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_degree", "The degree used in the poly kernel.", 0.0, Double.POSITIVE_INFINITY, 2.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_bias", "The bias used in the poly kernel.", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_sigma1", "The SVM kernel parameter sigma1 (Epanechnikov, Gaussian Combination, Multiquadric).", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_sigma2", "The SVM kernel parameter sigma2 (Gaussian Combination).", 0.0, Double.POSITIVE_INFINITY, 0.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_sigma3", "The SVM kernel parameter sigma3 (Gaussian Combination).", 0.0, Double.POSITIVE_INFINITY, 2.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_shift", "The SVM kernel parameter shift (polynomial, Multiquadric).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_a", "The SVM kernel parameter a (neural).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_b", "The SVM kernel parameter b (neural).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("max_basis_vectors", "Maximum number of basis vectors to be used.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("epsilon_tol", "Tolerance for gamma induced projections", 0.0, Double.POSITIVE_INFINITY, 1.0E-7);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("geometrical_tol", "Tolerance for geometry induced projections", 0.0, Double.POSITIVE_INFINITY, 1.0E-7);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

