/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel;

import edu.udo.cs.mySVM.Examples.Example;
import edu.udo.cs.mySVM.Examples.ExampleSet;
import edu.udo.cs.mySVM.Kernel.Kernel;
import edu.udo.cs.mySVM.SVM.SVMInterface;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.kernel.KernelModel;
import java.util.Iterator;

public abstract class AbstractMySVMModel
extends KernelModel {
    private ExampleSet model;
    private Kernel kernel;

    public AbstractMySVMModel() {
    }

    public AbstractMySVMModel(Attribute labelAttribute) {
        super(labelAttribute);
    }

    public AbstractMySVMModel(Attribute labelAttribute, ExampleSet model, Kernel kernel, int kernelType) {
        super(labelAttribute);
        this.model = model;
        this.kernel = kernel;
    }

    public abstract SVMInterface createSVM();

    public String getModelInfo() {
        return "SVM Model (" + this.model.getNumberOfSupportVectors() + " support vectors, b: " + this.model.get_b() + ")";
    }

    public boolean isClassificationModel() {
        return this.getLabel().isNominal();
    }

    public double getAlpha(int index) {
        return this.model.get_alpha(index);
    }

    public String getId(int index) {
        return this.model.getId(index);
    }

    public int getNumberOfExamples() {
        return this.model.count_examples();
    }

    public int getNumberOfAttributes() {
        return this.model.get_dim();
    }

    public double getAttributeValue(int exampleIndex, int attributeIndex) {
        Example example = this.model.get_example(exampleIndex);
        double value = 0.0;
        try {
            value = example.toDense()[attributeIndex];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return value;
    }

    public String getClassificationLabel(int index) {
        double y = this.model.get_y(index);
        if (y < 0.0) {
            return this.getLabel().getMapping().getNegativeString();
        }
        return this.getLabel().getMapping().getPositiveString();
    }

    public double getRegressionLabel(int index) {
        return this.model.get_y(index);
    }

    public double getFunctionValue(int index) {
        SVMInterface svm = this.createSVM();
        svm.init(this.kernel, this.model);
        return svm.predict(this.model.get_example(index));
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public ExampleSet getExampleSet() {
        return this.model;
    }

    public abstract void setPrediction(edu.udo.cs.yale.example.Example var1, double var2);

    public void performPrediction(edu.udo.cs.yale.example.ExampleSet exampleSet, Attribute predictedLabelAttribute) throws OperatorException {
        ExampleSet toPredict = new ExampleSet(exampleSet, exampleSet.getAttributes().getPredictedLabel(), this.model.getMeanVariances());
        SVMInterface svm = this.createSVM();
        svm.init(this.kernel, this.model);
        svm.predict(toPredict);
        Iterator reader = exampleSet.iterator();
        int k = 0;
        while (reader.hasNext()) {
            this.setPrediction((edu.udo.cs.yale.example.Example)reader.next(), toPredict.get_y(k++));
        }
    }

    public String toString() {
        return this.model.toString(0, false);
    }
}

