/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel;

import edu.udo.cs.mySVM.Examples.ExampleSet;
import edu.udo.cs.mySVM.Kernel.Kernel;
import edu.udo.cs.mySVM.Kernel.KernelDot;
import edu.udo.cs.mySVM.Kernel.KernelEpanechnikov;
import edu.udo.cs.mySVM.Kernel.KernelGaussianCombination;
import edu.udo.cs.mySVM.Kernel.KernelMultiquadric;
import edu.udo.cs.mySVM.Kernel.KernelNeural;
import edu.udo.cs.mySVM.Kernel.KernelPolynomial;
import edu.udo.cs.mySVM.Kernel.KernelRadial;
import edu.udo.cs.mySVM.SVM.SVMInterface;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.learner.AbstractLearner;
import edu.udo.cs.yale.operator.learner.kernel.AbstractMySVMModel;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.performance.EstimatedPerformance;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMySVMLearner
extends AbstractLearner {
    public static final String[] KERNEL_TYPES = new String[]{"dot", "radial", "polynomial", "neural", "epachnenikov", "gaussian_combination", "multiquadric"};
    public static final int KERNEL_DOT = 0;
    public static final int KERNEL_RADIAL = 1;
    public static final int KERNEL_POLYNOMIAL = 2;
    public static final int KERNEL_NEURAL = 3;
    public static final int KERNEL_EPANECHNIKOV = 4;
    public static final int KERNEL_GAUSSIAN_COMBINATION = 5;
    public static final int KERNEL_MULTIQUADRIC = 6;
    private SVMInterface svm = null;
    private Kernel kernel;
    private ExampleSet svmExamples;

    public AbstractMySVMLearner(OperatorDescription description) {
        super(description);
    }

    protected Kernel getKernel() {
        return this.kernel;
    }

    protected SVMInterface getSVM() {
        return this.svm;
    }

    @Override
    public boolean shouldDeliverOptimizationPerformance() {
        return this.getParameterAsBoolean("return_optimization_performance");
    }

    @Override
    public PerformanceVector getOptimizationPerformance() {
        double finalFitness = this.getFitness(this.svmExamples.get_alphas(), this.svmExamples.get_ys(), this.kernel);
        PerformanceVector result = new PerformanceVector();
        result.addCriterion(new EstimatedPerformance("svm_objective_function", finalFitness, 1, false));
        result.addCriterion(new EstimatedPerformance("no_support_vectors", this.svmExamples.getNumberOfSupportVectors(), 1, true));
        return result;
    }

    @Override
    public boolean shouldCalculateWeights() {
        return this.getParameterAsBoolean("calculate_weights");
    }

    @Override
    public AttributeWeights getWeights(edu.udo.cs.yale.example.ExampleSet exampleSet) throws OperatorException {
        if (this.getParameterAsInt("kernel_type") != 0) {
            throw new UserError((Operator)this, 916, this, (Object)"Cannot create weights for nonlinear kernel!");
        }
        double[] weights = this.svm.getWeights();
        AttributeWeights weightVector = new AttributeWeights();
        int i = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            weightVector.setWeight(attribute.getName(), weights[i++]);
        }
        return weightVector;
    }

    public abstract SVMInterface createSVM(Attribute var1, Kernel var2, ExampleSet var3, edu.udo.cs.yale.example.ExampleSet var4) throws OperatorException;

    public abstract AbstractMySVMModel createSVMModel(Attribute var1, ExampleSet var2, Kernel var3, int var4);

    @Override
    public Model learn(edu.udo.cs.yale.example.ExampleSet exampleSet) throws OperatorException {
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label.isNominal() && label.getMapping().size() != 2) {
            throw new UserError((Operator)this, 114, this.getName(), (Object)label.getName());
        }
        this.svmExamples = new ExampleSet(exampleSet, label, this.getParameterAsBoolean("scale"));
        int kernelType = this.getParameterAsInt("kernel_type");
        int cacheSize = this.getParameterAsInt("kernel_cache");
        this.kernel = AbstractMySVMLearner.createKernel(kernelType);
        if (kernelType == 1) {
            ((KernelRadial)this.kernel).setGamma(this.getParameterAsDouble("kernel_gamma"));
        } else if (kernelType == 2) {
            ((KernelPolynomial)this.kernel).setDegree(this.getParameterAsDouble("kernel_degree"));
        } else if (kernelType == 3) {
            ((KernelNeural)this.kernel).setParameters(this.getParameterAsDouble("kernel_a"), this.getParameterAsDouble("kernel_b"));
        } else if (kernelType == 4) {
            ((KernelEpanechnikov)this.kernel).setParameters(this.getParameterAsDouble("kernel_sigma1"), this.getParameterAsDouble("kernel_degree"));
        } else if (kernelType == 5) {
            ((KernelGaussianCombination)this.kernel).setParameters(this.getParameterAsDouble("kernel_sigma1"), this.getParameterAsDouble("kernel_sigma2"), this.getParameterAsDouble("kernel_sigma3"));
        } else if (kernelType == 6) {
            ((KernelMultiquadric)this.kernel).setParameters(this.getParameterAsDouble("kernel_sigma1"), this.getParameterAsDouble("kernel_shift"));
        }
        this.kernel.init(this.svmExamples, cacheSize);
        this.svm = this.createSVM(label, this.kernel, this.svmExamples, exampleSet);
        this.svm.init(this.kernel, this.svmExamples);
        this.svm.train();
        return this.createSVMModel(label, this.svmExamples, this.kernel, kernelType);
    }

    private double getFitness(double[] alphas, double[] ys, Kernel kernel) {
        double sum = 0.0;
        int numberSV = 0;
        int i = 0;
        while (i < ys.length) {
            sum += alphas[i];
            if (alphas[i] > 0.0) {
                ++numberSV;
            }
            ++i;
        }
        double matrixSum = 0.0;
        int i2 = 0;
        while (i2 < ys.length) {
            if (alphas[i2] != 0.0) {
                int j = 0;
                while (j < ys.length) {
                    if (alphas[j] != 0.0) {
                        matrixSum += alphas[i2] * alphas[j] * ys[i2] * ys[j] * kernel.calculate_K(i2, j);
                    }
                    ++j;
                }
            }
            ++i2;
        }
        return sum - 0.5 * matrixSum;
    }

    public static Kernel createKernel(int kernelType) {
        switch (kernelType) {
            case 0: {
                return new KernelDot();
            }
            case 1: {
                return new KernelRadial();
            }
            case 2: {
                return new KernelPolynomial();
            }
            case 3: {
                return new KernelNeural();
            }
            case 4: {
                return new KernelEpanechnikov();
            }
            case 5: {
                return new KernelGaussianCombination();
            }
            case 6: {
                return new KernelMultiquadric();
            }
        }
        return new KernelDot();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory("kernel_type", "The SVM kernel type", KERNEL_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_gamma", "The SVM kernel parameter gamma (radial).", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_sigma1", "The SVM kernel parameter sigma1 (epanechnikov, gaussian combination, multiquadric).", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_sigma2", "The SVM kernel parameter sigma2 (gaussian combination).", 0.0, Double.POSITIVE_INFINITY, 0.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_sigma3", "The SVM kernel parameter sigma3 (gaussian combination).", 0.0, Double.POSITIVE_INFINITY, 2.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_shift", "The SVM kernel parameter shift (multiquadric).", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_degree", "The SVM kernel parameter degree (polynomial, epanechnikov).", 0.0, Double.POSITIVE_INFINITY, 2.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_a", "The SVM kernel parameter a (neural).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_b", "The SVM kernel parameter b (neural).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt("kernel_cache", "Size of the cache for kernel evaluations im MB ", 0, Integer.MAX_VALUE, 200));
        type = new ParameterTypeDouble("C", "The SVM complexity constant. Use -1 for different C values for positive and negative.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("convergence_epsilon", "Precision on the KKT conditions", 0.0, Double.POSITIVE_INFINITY, 0.001);
        types.add(type);
        types.add(new ParameterTypeInt("max_iterations", "Stop after this many iterations", 1, Integer.MAX_VALUE, 100000));
        types.add(new ParameterTypeBoolean("scale", "Scale the example values and store the scaling parameters for test set.", true));
        types.add(new ParameterTypeBoolean("calculate_weights", "Indicates if attribute weights should be returned.", false));
        types.add(new ParameterTypeBoolean("return_optimization_performance", "Indicates if final optimization fitness should be returned as performance.", false));
        return types;
    }
}

