/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.igss.utility;

import edu.udo.cs.yale.operator.learner.igss.hypothesis.Hypothesis;
import edu.udo.cs.yale.operator.learner.igss.utility.AbstractUtility;
import edu.udo.cs.yale.operator.learner.igss.utility.Coverage;

public class Binomial
extends AbstractUtility {
    public Binomial(double[] priors, int large) {
        super(priors, large);
    }

    public double utility(double totalWeight, double totalPositiveWeight, Hypothesis hypo) {
        double g = hypo.getCoveredWeight() / totalWeight;
        double p = hypo.getPositiveWeight() / hypo.getCoveredWeight();
        if (hypo.getPrediction() == 1) {
            return Math.sqrt(g) * (p - this.priors[1]);
        }
        return Math.sqrt(g) * (p - this.priors[0]);
    }

    public double conf(double totalWeight, double delta) {
        double inverseNormal = this.inverseNormal(1.0 - delta / 4.0);
        return Math.sqrt(inverseNormal / (2.0 * Math.sqrt(totalWeight))) + inverseNormal / (2.0 * Math.sqrt(totalWeight)) + Math.pow(inverseNormal / (2.0 * Math.sqrt(totalWeight)), 1.5);
    }

    public double conf(double totalWeight, double totalPositiveWeight, Hypothesis hypo, double delta) {
        double g = hypo.getCoveredWeight() / totalWeight;
        double p = hypo.getPositiveWeight() / hypo.getCoveredWeight();
        double sg = this.variance(g, totalWeight);
        double sp = this.variance(p, hypo.getCoveredWeight());
        double inverseNormal = this.inverseNormal(1.0 - delta / 4.0);
        return Math.sqrt(sg * inverseNormal) + sp * inverseNormal + Math.sqrt(sg * inverseNormal) * sp * inverseNormal;
    }

    private double variance(double p, double totalWeight) {
        return p * (1.0 - p) / totalWeight;
    }

    public double confSmallM(double totalExampleWeight, double delta) {
        double term = Math.log(4.0 / delta) / (2.0 * totalExampleWeight);
        return Math.sqrt(term) + Math.pow(term, 0.25) + Math.pow(term, 0.75);
    }

    public double getUpperBound(double totalWeight, double totalPositiveWeight, Hypothesis hypo, double delta) {
        double p0 = hypo.getPrediction() == 1 ? this.priors[1] : this.priors[0];
        Coverage cov = new Coverage(this.priors, this.large);
        Hypothesis h = hypo.clone();
        h.setCoveredWeight(hypo.getPositiveWeight());
        double g = cov.utility(totalWeight, totalPositiveWeight, h);
        double conf = cov.confidenceIntervall(totalWeight, delta);
        return Math.sqrt(g + conf) * (1.0 - p0);
    }
}

